#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Vendor.h>
#include <X11/xpm.h>
#include <stdio.h>
#include "IndicatorP.h"

#define INDC_WIDTH  (144)
#define INDC_HEIGHT (30)

#define sDisp      XtDisplay(iw)
#define sScreen    XtScreen(iw)
#define sRoot      XRootWindowOfScreen(XtScreen(iw))
#define sWidth     iw->core.width
#define sHeight    iw->core.height
#define sPixmap    iw->indicator.pixmap
#define sBGC       iw->indicator.gc[0]
#define sGC(i)     iw->indicator.gc[i]

static char* colors[] =
{
        "#282828",              /* dark gray   */
        "#00287A",              /* dark blue   */
        "#00A7FF",              /* blue        */
        "#0C5B00",              /* dark green  */
        "#49DC00",              /* green       */
        "#615600",              /* dark yellow */
        "#EBD000",              /* yellow      */
        "#613D00",              /* dark orange */
        "#EB9C00",              /* orange      */
        "#620000",              /* dark red    */
        "#E10000",              /* red         */
};

static struct st_meter {
        long threshold;
        int  color;
} meter[] = {
{    0, 1}, {    1, 1}, {    2, 1}, {    3, 1},
{    4, 1}, {    5, 1}, {    7, 1},
{   10, 3}, {   13, 3}, {   19, 3}, {   26, 3},
{   37, 3}, {   51, 3}, {   71, 3},
{  100, 5}, {  138, 5}, {  193, 5}, {  268, 5},
{  372, 5}, {  517, 5}, {  719, 5},
{ 1000, 7}, { 1389, 7}, { 1930, 7}, { 2682, 7},
{ 3727, 7}, { 5179, 7}, { 7196, 7},
{10000, 9}, {13894, 9}, {19306, 9}, {26827, 9},
{37275, 9}, {51794, 9}, {71968, 9}, 
};


#define offset(field) XtOffsetOf(IndicatorRec, field)
static XtResource resources[] = {
  { XtNinRate, XtCInRate, XtRInt, sizeof(int),
            offset(indicator.in_rate), XtRImmediate, (XtPointer)0 },
  { XtNoutRate, XtCOutRate, XtRInt, sizeof(int),
            offset(indicator.out_rate), XtRImmediate, (XtPointer)0 },
};
#undef offset

static void Initialize();
static void Resize();
static void Redisplay();
static Boolean SetValues();
static void Destroy();
static XtGeometryResult QueryGeometry();
static char defaultTranslation[] = "";
static XtActionsRec actions[] = {{NULL, NULL}};
static void ShowIndicator();

IndicatorClassRec indicatorClassRec = {
  {
  /* superclass             */ (WidgetClass) &coreClassRec,
  /* class_name             */ "Indicator",
  /* widget_size            */ sizeof(IndicatorRec),
  /* class_initialize       */ NULL,
  /* class_part_initialize  */ NULL,
  /* class_inited           */ FALSE,
  /* initialize             */ Initialize,
  /* initialize_hook        */ NULL,
  /* realize                */ XtInheritRealize,
  /* actions                */ actions,
  /* num_actions            */ XtNumber(actions),
  /* resources              */ resources,
  /* num_resourece          */ XtNumber(resources),
  /* xrm_class              */ NULLQUARK,
  /* compress_motion        */ TRUE,
  /* compress_exposure      */ TRUE,
  /* compress_enterleave    */ TRUE,
  /* visible_interest       */ FALSE,
  /* destroy                */ Destroy,
  /* resize                 */ Resize,
  /* expose                 */ Redisplay,
  /* set_values             */ SetValues,
  /* set_values_hook        */ NULL,
  /* set_values_almoset     */ XtInheritSetValuesAlmost,
  /* get_values_hook        */ NULL,
  /* accept_focus           */ NULL,
  /* version                */ XtVersion,
  /* callback_private       */ NULL,
  /* tm_table               */ defaultTranslation,
  /* query_geometry         */ QueryGeometry,
  /* display_accelator      */ XtInheritDisplayAccelerator,
  /* extention              */ NULL
  },{
  /* foo                    */ 0
  }
};
WidgetClass indicatorWidgetClass = (WidgetClass)&indicatorClassRec;

static GC
GetGC(IndicatorWidget iw, XColor fg)
{
        XGCValues values;
        XtGCMask  mask;

        values.foreground = fg.pixel;
        values.background = iw->core.background_pixel;
        values.graphics_exposures = False;
        mask = GCForeground | GCBackground | GCGraphicsExposures;
        return XCreateGC(sDisp, sPixmap, mask, &values);
}

static void
GetAllGC(IndicatorWidget iw)
{
        int i;
        for(i=0; i<11; i++) {
                sGC(i) = GetGC(iw, iw->indicator.color[i]);
        }
}

static void
GetColor(IndicatorWidget iw)
{
        XColor exact;
        Colormap cmap;
        int i;

        cmap=DefaultColormapOfScreen(sScreen);
        for(i=0; i<11; i++) {
                XAllocNamedColor(sDisp, cmap, colors[i],
                                 &(iw->indicator.color[i]), &exact);
        }
}

static void
Initialize(Widget wreq, Widget wnew)
{
        IndicatorWidget iw = (IndicatorWidget) wnew;
        Pixmap Mask;
        XpmAttributes Attr;

        if (sWidth == 0) {
                sWidth = INDC_WIDTH;
        }
        if (sHeight == 0) {
                sHeight = INDC_HEIGHT;
        }
        sPixmap = XCreatePixmap(sDisp, sRoot, sWidth, sHeight,
                               DefaultDepthOfScreen(sScreen));
        GetColor(iw);
        GetAllGC(iw);
        XFillRectangle(sDisp, sPixmap, sBGC,  0, 0, sWidth, sHeight);
        ShowIndicator(iw);
}

static void
Redisplay(Widget w, XExposeEvent *event)
{
        IndicatorWidget iw = (IndicatorWidget) w;
        int x,y;
        int width, height;

        if (XtIsRealized(w)) {
                if (event) {
                        x = event->x;
                        y = event->y;
                        width = event->width;
                        height = event->height;
                } else {
                        x = 0;
                        y = 0;
                        width = sWidth;
                        height = sHeight;
                }
                XCopyArea(sDisp, sPixmap, XtWindow(iw), sBGC,
                          x, y, width, height, x, y);
        }
}


static Boolean
SetValues(Widget wcur, Widget wreq, Widget wnew)
{
        IndicatorWidget cur = (IndicatorWidget) wcur;
        IndicatorWidget new = (IndicatorWidget) wnew;
        Boolean redraw = False;

        if (cur->indicator.in_rate != new->indicator.in_rate ||
            cur->indicator.out_rate != new->indicator.out_rate) {
                ShowIndicator(new);
        }

        return redraw;
}

static void
Destroy(Widget w)
{
        IndicatorWidget iw = (IndicatorWidget) w;
        Colormap cmap;
        int i;
        cmap=DefaultColormapOfScreen(sScreen);
        if (sPixmap)
                XFreePixmap(sDisp, sPixmap);
        for(i=0; i<11; i++) {
                if (sGC(i)) XFreeGC(sDisp, sGC(i));
                XFreeColors(sDisp, cmap, 
                            &iw->indicator.color[i].pixel, 1, 0);
        }
}

static void Resize(Widget w)
{
        IndicatorWidget iw = (IndicatorWidget) w;

        return;
}

static XtGeometryResult
QueryGeometry(Widget w, XtWidgetGeometry *proposed, XtWidgetGeometry *answer)
{
        IndicatorWidget iw = (IndicatorWidget) w;

        answer->request_mode = CWWidth | CWHeight;
        answer->width  = sWidth;
        answer->height = sHeight;
        return XtGeometryAlmost;
}

static void
indicate(IndicatorWidget iw, long num, long old, long threshold,
         int x, int y, GC offgc, GC ongc)
{
        if (num > old && num > threshold) {
                XFillRectangle(sDisp, sPixmap, ongc, x*4+2, y*14+2, 2, 12);
        }
        if (num < old && num <= threshold) {
                XFillRectangle(sDisp, sPixmap, offgc, x*4+2, y*14+2, 2, 12);
        }
}

static void
ShowIndicator(IndicatorWidget iw)
{
        static old_in  = 100000;
        static old_out = 100000;
        long in  = iw->indicator.in_rate;
        long out = iw->indicator.out_rate;
        XExposeEvent rrect;
        int i;


        if (old_in != in) {
                for(i=0; i<35; i++) {
                        indicate(iw, in, old_in, meter[i].threshold,  i, 0,
                                 sGC(meter[i].color), sGC(meter[i].color+1));
                }
                rrect.x = 2;
                rrect.y = 2;
                rrect.width = 140;
                rrect.height = 12;
                Redisplay((Widget)iw, &rrect);
                old_in = in;
        }

        if (old_out != out) {
                for(i=0; i<35; i++) {
                        indicate(iw, out, old_out, meter[i].threshold, i, 1,
                                 sGC(meter[i].color), sGC(meter[i].color+1));
                }
                rrect.x = 2;
                rrect.y = 16;
                rrect.width = 140;
                rrect.height = 12;
                Redisplay((Widget) iw, &rrect);
                old_out = out;
        }
}
