// ----------------------------------------------------------------------
//
// RWMatrix.h
//
// XbaeMatrix widget C++ header file for Rogue Wave View.h++ library.
//
// ---------------------------------------------------------------------

/*
 * Copyright(c) 1995 Arcada Software, Inc.
 *                        All rights reserved
 * Permission to use, copy, modify and distribute this material for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of Aracada not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * Bellcore.
 *
 * ARACADA MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL ARACADA OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES RELAT-
 * ING TO THE SOFTWARE.
 *
 * RWMatrix.h: Author: Mark Steckel, Arcada Software, Inc. 
 *                     msteckel@arcada.com
 *
 * Revisions:
 *	10/93:  Initial release
 */

#ifdef RWMATRIX_CXX
static char sccsid_h[] = "@(#)RWMatrix.h   0.1 95/09/28  Arcada Software Inc."
#endif


#ifndef _RWMATRIX_H
#define _RWMATRIX_H

// The following #defines can be moved to <rw/TypeId.h>
//
// Rogue Wave reserves 0x8000 & higher for RWTools.h++
// and 0x7000 through 0x7FFF for View.h++. Anything 
// below 0x7000 is considered free and is safe to use,
// at least as far as Rogue Wave is concernced.
//
// __RWMATRIX_OFFSET makes it easy to change the type Id values
// on the off chance that you have "wrapped" another widget
// and now have a clash with the wrapped version of XbaeMatrix.

#define __RWMATRIX_OFFSET                          0x6100

#define __RWMATRIX                                 (__RWMATRIX_OFFSET + 0)
#define __RWMATRIXMODIFYVERIFYCALLBACK             (__RWMATRIX_OFFSET + 1)
#define __RWMATRIXENTERCELLCALLBACK                (__RWMATRIX_OFFSET + 2)
#define __RWMATRIXLEAVECELLCALLBACK                (__RWMATRIX_OFFSET + 3)
#define __RWMATRIXTRAVERSECELLCALLBACK             (__RWMATRIX_OFFSET + 4)
#define __RWMATRIXSELECTCELLCALLBACK               (__RWMATRIX_OFFSET + 5)
#define __RWMATRIXDRAWCELLCALLBACK                 (__RWMATRIX_OFFSET + 6)
#define __RWMATRIXDEFAULTACTIONCALLBACK            (__RWMATRIX_OFFSET + 7)

#include <rw/Xrw/AnyCB.h>
#include <rw/Xrw/Manager.h>
#include <rw/Xrw/ResObj.h>

#include "Matrix.h"

class RWMatrix : public RWManager {
 public:

  // Constructors
    RWMatrix (RWController    * parent, 
	      const RWCString & name,
	      RWBoolean         managed = False)
      {
	widget = XtCreateWidget ((String)name.data(), 
				 xbaeMatrixWidgetClass,
				 parent->getWidget(),
				 &sdargs, 
				 sargcnt);
	setBackpointer();
	if (managed)
	  this->manage();
	sargcnt = 0;
      }

    RWMatrix (RWController    * parent,
	   const RWCString & name,
	   RWResourceObj   & creationTimeResources,
	   RWBoolean         managed = False)
      {
	widget = XtCreateWidget ((String)name.data(), 
				 xbaeMatrixWidgetClass,
				 parent->getWidget(),
				 creationTimeResources.getArgs(), 
				 creationTimeResources.getArgCnt());
	setBackpointer();
	if (managed)
	  this->manage();
      }

    RWMatrix (Widget w, RWBoolean managed = False)
      {
	widget = w;
	setBackpointer();
	if (managed)
	  this->manage();
        sargcnt = 0;
      }

    RWMatrix()
      {}

  // Destructor
    ~RWMatrix()
      {}

/****************************************************************
 * RESOURCE MEMBER FUNCTIONS
 ****************************************************************/

  CSG_RESOURCE(RWMatrix,AltRowCount,XmNaltRowCount,int)
  CSG_RESOURCE(RWMatrix,BoldLabels,XmNboldLabels,Boolean)
  CSG_RESOURCE(RWMatrix,CellBackgrounds,XmNcellBackgrounds,XtPointer)
  CSG_RESOURCE(RWMatrix,CellHighlightThichness,XmNcellHighlightThickness,Dimension)
  CSG_RESOURCE(RWMatrix,CellMarginHeight,XmNcellMarginHeight,Dimension)
  CSG_RESOURCE(RWMatrix,CellMarginWidth,XmNcellMarginWidth,Dimension)
  CSG_RESOURCE(RWMatrix,CellShadowThickness,XmNcellShadowThickness,Dimension)
  CSG_RESOURCE(RWMatrix,CellShadowType,XmNcellShadowType,unsigned char)
  CSG_RESOURCE(RWMatrix,Cells,XmNcells,XtPointer)
  CSG_RESOURCE(RWMatrix,Colors,XmNcolors,XtPointer)
  CSG_RESOURCE(RWMatrix,ColumnAlignments,XmNcolumnAlignments,AlignmentArray)
  CSG_RESOURCE(RWMatrix,ColumnLabelAlignments,XmNcolumnLabelAlignments,AlignmentArray)
  CSG_RESOURCE(RWMatrix,ColumnLabels,XmNcolumnLabels,XtPointer)
  CSG_RESOURCE(RWMatrix,ColumnMaxLengths,XmNcolumnMaxLengths,XtPointer)
  CSG_RESOURCE(RWMatrix,ColumnWidths,XmNcolumnWidths,XtPointer)
  CSG_RESOURCE(RWMatrix,Columns,XmNcolumns,int)
  CSG_RESOURCE(RWMatrix,DoubleClickInterval,XmNdoubleClickInterval,int)
  CSG_RESOURCE(RWMatrix,EvenRowBackground,XmNevenRowBackground,Pixel)
  CSG_RESOURCE(RWMatrix,FixedColumns,XmNfixedColumns,Dimension)
  CSG_RESOURCE(RWMatrix,FixedRows,XmNfixedRows,Dimension)

// This hides the resource functions in RWManager.
// I am fairly certain that omitting it here does
// not present a problem.
//
//  CSG_RESOURCE(RWMatrix,FontList,XmNfontList,XmFontList)


  CSG_RESOURCE(RWMatrix,GridLineColor,XmNgridLineColor,Pixel)
  CSG_RESOURCE(RWMatrix,GridType,XmNgridType,unsigned char)
    G_RESOURCE(RWMatrix,HorizontalScrollBar,XmNhorizontalScrollBar,Widget)
  CSG_RESOURCE(RWMatrix,LabelFont,XmNlabelFont,XmFontList)
  CSG_RESOURCE(RWMatrix,LeftColumn,XmNleftColumn,int)
  CSG_RESOURCE(RWMatrix,ReverseSelect,XmNreverseSelect,Boolean)
  CSG_RESOURCE(RWMatrix,RowLabelAlignment,XmNrowLabelAlignment,Alignment)
  CSG_RESOURCE(RWMatrix,RowLabelWidth,XmNrowLabelWidth,short)
  CSG_RESOURCE(RWMatrix,RowLabels,XmNrowLabels,XtPointer)
  CSG_RESOURCE(RWMatrix,Rows,XmNrows,int)
  CSG_RESOURCE(RWMatrix,SelectScrollVisible,XmNselectScrollVisible,Boolean)
  CSG_RESOURCE(RWMatrix,SelectedBackground,XmNselectedBackground,Pixel)
  CSG_RESOURCE(RWMatrix,SelectedCells,XmNselectedCells,XtPointer)
  CSG_RESOURCE(RWMatrix,SelectedForeground,XmNselectedForeground,Pixel)
  CSG_RESOURCE(RWMatrix,ShadowType,XmNshadowType,unsigned char)
  CSG_RESOURCE(RWMatrix,Space,XmNspace,Dimension)
  CSG_RESOURCE(RWMatrix,TextBackground,XmNtextBackground,Pixel)
  CSG_RESOURCE(RWMatrix,TextTranslations,XmNtextTranslations,XtTranslations)
  CSG_RESOURCE(RWMatrix,TopRow,XmNtopRow,int)
  CSG_RESOURCE(RWMatrix,TrailingFixedColumns,XmNtrailingFixedColumns,Dimension)
  CSG_RESOURCE(RWMatrix,TrailingFixedRows,XmNtrailingFixedRows,Dimension)
    G_RESOURCE(RWMatrix,VerticalScrollBar,XmNverticalScrollBar,Widget)
  CSG_RESOURCE(RWMatrix,VisibleColumns,XmNvisibleColumns,Dimension)
  CSG_RESOURCE(RWMatrix,VisibleRows,XmNvisibleRows,Dimension)


/****************************************************************
 * RESOURCE CALLBACK FUNCTIONS
 ****************************************************************/
    
  C_CALLBACK(RWMatrix,DefaultActionCallback,DefaultActionMethod,XmNdefaultActionCallback)
  C_CALLBACK(RWMatrix,DrawCellCallback,DrawCellMethod,XmNdrawCellCallback)
  C_CALLBACK(RWMatrix,EnterCellCallback,EnterCellMethod,XmNenterCellCallback)
  C_CALLBACK(RWMatrix,LeaveCellCallback,LeaveCellMethod,XmNleaveCellCallback)
  C_CALLBACK(RWMatrix,ModifyVerifyCallback,ModifyVerifyMethod,XmNmodifyVerifyCallback)
  C_CALLBACK(RWMatrix,SelectCellCallback,SelectCellMethod,XmNselectCellCallback)
  C_CALLBACK(RWMatrix,TraverseCellCallback,TraverseCellMethod,XmNtraverseCellCallback)

/****************************************************************
 * CONVENIENCE FUNCTIONS
 ****************************************************************/
  
  void RWMatrix::setCell(int row, int column, const String value)
  {
    XbaeMatrixSetCell (widget, row, column, value); 
  }
  void RWMatrix::editCell(int row, int column)
  {
    XbaeMatrixEditCell (widget, row, column); 
  }
  void RWMatrix::selectCell(int row, int column)
  {
    XbaeMatrixSelectCell (widget, row, column); 
  }
  void RWMatrix::selectRow(int row)
  {
    XbaeMatrixSelectRow (widget, row); 
  }
  void RWMatrix::selectColumn(int column)
  {
    XbaeMatrixSelectColumn (widget, column); 
  }
  void RWMatrix::deselectAll()
  {
    XbaeMatrixDeselectAll (widget);                             
  }
  void RWMatrix::deselectCell(int row, int column)
  {
    XbaeMatrixDeselectCell (widget, row, column); 
  }
  void RWMatrix::deselectRow(int row)
  {
    XbaeMatrixDeselectRow (widget, row); 
  }
  void RWMatrix::deselectColumn(int column)
  {
    XbaeMatrixDeselectColumn (widget, column); 
  }
  String RWMatrix::getCell(int row, int column)
  {
    return (XbaeMatrixGetCell (widget, row, column)); 
  }
  Boolean RWMatrix::commitEdit(Boolean unmap)
  {
    return (XbaeMatrixCommitEdit (widget, unmap)); 
  }
  void RWMatrix::cancelEdit(Boolean unmap)
  {
    XbaeMatrixCancelEdit (widget, unmap); 
  }
  void RWMatrix::addRows(int position, 
  		       String *rows, 
  		       String *labels, 
  		       Pixel *colors, 
  		       int num_rows)
  {
    XbaeMatrixAddRows (widget, position, rows, labels, colors, num_rows); 
  }
  void RWMatrix::deleteRows(int position, int num_rows)
  {
    XbaeMatrixDeleteRows (widget, position, num_rows); 
  }
  void RWMatrix::addColumns(int position, 
  			  String *columns, 
  			  String *labels, 
  			  short *widths, 
  			  int *max_lengths, 
  			  unsigned char *alignments, 
  			  unsigned char *label_alignments, 
  			  Pixel *colors, 
  			  int num_columns)
  {
    XbaeMatrixAddColumns (widget, 
  			position, 
  			columns, 
  			labels, 
  			widths, 
  			max_lengths, 
  			alignments, 
  			label_alignments, 
  			colors, 
  			num_columns); 
  }
  void RWMatrix::deleteColumns(int position, int num_columns)
  {
    XbaeMatrixDeleteColumns (widget, position, num_columns); 
  }
  void RWMatrix::setRowColors(int position, Pixel *colors, int num_colors)
  {
    XbaeMatrixSetRowColors (widget, position, colors, num_colors); 
  }
  void RWMatrix::setColumnColors(int position, Pixel *colors, int num_colors)
  {
    XbaeMatrixSetColumnColors (widget, position, colors, num_colors); 
  }
  void RWMatrix::setCellColor(int row, int column, Pixel color)
  {
    XbaeMatrixSetCellColor (widget, row, column, color); 
  }
  void RWMatrix::setRowBackgrounds(int position, Pixel *colors, int num_colors)
  {
    XbaeMatrixSetRowBackgrounds (widget, position, colors, num_colors); 
  }
  void RWMatrix::setColumnBackgrounds(int position, 
				      Pixel *colors, 
				      int num_colors)
  {
    XbaeMatrixSetColumnBackgrounds (widget, position, colors, num_colors); 
  }
  void RWMatrix::setCellBackground(int row, int column, Pixel color)
  {
    XbaeMatrixSetCellBackground (widget, row, column, color); 
  }
  int RWMatrix::getEventRowColumn(XEvent *event, int *row, int *column)
  {
    return (XbaeMatrixGetEventRowColumn (widget, event, row, column)); 
  }
  void RWMatrix::getCurrentCell(int *row, int *column)
  {
    XbaeMatrixGetCurrentCell (widget, row, column); 
  }
  void RWMatrix::refresh()
  {
    XbaeMatrixRefresh (widget);                                 
  }
  int RWMatrix::visibleColumns()
  {
    return (XbaeMatrixVisibleColumns (widget)); 
  }
  int RWMatrix::visibleRows()
  {
    return (XbaeMatrixVisibleRows (widget)); 
  }
               
  // **** RW TOOLS MEMBER FUNCTIONS ****
    virtual RWClassID isA() const {return __RWMATRIX;}

};


// --------------------------------------------------------------------------


// Class definitions for all of the callback structures 
// supported by the XbaeMatrix widget.

/*
 * Struct passed to modifyVerifyCallback
 */
class RWMatrixModifyVerifyCallback : public RWAnyCallback
{
 public:
  RWMatrixModifyVerifyCallback (XbaeMatrixModifyVerifyCallbackStruct * cbs)
    : RWAnyCallback ((XmAnyCallbackStruct *) cbs) {}
  ~RWMatrixModifyVerifyCallback() {}

  int                          getRow()      { return shadow()->row; }
  int                          getColumn()   { return shadow()->column; }
  XmTextVerifyCallbackStruct * getVerify()   { return shadow()->verify; }
  const char                 * getPrevtext() { return shadow()->prev_text; }

  void setColumn   (int column)            { shadow()->column = column; }
  void setRow      (int row)               { shadow()->row = row; }
  void setPrevtext (const char *prev_text) { shadow()->prev_text = prev_text; }
  void setVerify   (XmTextVerifyCallbackStruct * verify) 
                                           { shadow()->verify = verify; }

  virtual RWClassID isA() const {return __RWMATRIXMODIFYVERIFYCALLBACK;}

 private:
  XbaeMatrixModifyVerifyCallbackStruct * shadow()
    { return (XbaeMatrixModifyVerifyCallbackStruct *) shadow_;}
};

/*
 * Struct passed to enterCellCallback
 */
class RWMatrixEnterCellCallback : public RWAnyCallback
{
 public:
  RWMatrixEnterCellCallback (XbaeMatrixEnterCellCallbackStruct * cbs)
    : RWAnyCallback ((XmAnyCallbackStruct *) cbs) {}
  ~RWMatrixEnterCellCallback() {}

  int     getRow()    { return shadow()->row; }
  int     getColumn() { return shadow()->column; }
  Boolean getDoit()   { return shadow()->doit; }

  void setRow    (int row)      { shadow()->row = row; }
  void setColumn (int column)   { shadow()->column = column; }
  void setDoit   (Boolean doit) { shadow()->doit = doit; }

  virtual RWClassID isA() const {return __RWMATRIXENTERCELLCALLBACK;}

 private:
  XbaeMatrixEnterCellCallbackStruct * shadow()
    { return (XbaeMatrixEnterCellCallbackStruct *) shadow_;}
};

/*
 * Struct passed to leaveCellCallback
 */
class RWMatrixLeaveCellCallback : public RWAnyCallback
{
 public:
  RWMatrixLeaveCellCallback (XbaeMatrixLeaveCellCallbackStruct * cbs)
    : RWAnyCallback ((XmAnyCallbackStruct *) cbs) {}
  ~RWMatrixLeaveCellCallback() {}

  int     getRow()    { return shadow()->row; }
  int     getColumn() { return shadow()->column; }
  Boolean getDoit()   { return shadow()->doit; }
  String  getValue()  { return shadow()->value; }

  void setRow    (int row)      { shadow()->row = row; }
  void setColumn (int column)   { shadow()->column = column; }
  void setDoit   (Boolean doit) { shadow()->doit = doit; }
  void setValue  (String value) { shadow()->value = value; }

  virtual RWClassID isA() const {return __RWMATRIXLEAVECELLCALLBACK;}

 private:
  XbaeMatrixLeaveCellCallbackStruct * shadow()
    { return (XbaeMatrixLeaveCellCallbackStruct *) shadow_;}
};

/*
 * Struct passed to traverseCellCallback
 */
class RWMatrixTraverseCellCallback : public RWAnyCallback
{
 public:
  RWMatrixTraverseCellCallback (XbaeMatrixTraverseCellCallbackStruct * cbs)
    : RWAnyCallback ((XmAnyCallbackStruct *) cbs) {}
  ~RWMatrixTraverseCellCallback() {}

  int      getRow()                  { return shadow()->row; }
  int      getColumn()               { return shadow()->column; }
  int      getNextRow()              { return shadow()->next_row; }
  int      getNextColumn()           { return shadow()->next_column; }
  int      getFixedRows()            { return shadow()->fixed_rows; }
  int      getNumRows()              { return shadow()->num_rows; }
  int      getNumColumns()           { return shadow()->num_columns; }
  String   getParam()                { return shadow()->param; }
  XrmQuark getQparam()               { return shadow()->qparam; }
  int      getFixedColumns()         { return shadow()->fixed_columns; }
  int      getLeadingFixedRows()     { return shadow()->leading_fixed_rows; }
  int      getLeadingFixedColumns()  { return shadow()->leading_fixed_columns;}
  int      getTrailingFixedRows()    { return shadow()->trailing_fixed_rows; }
  int      getTrailingFixedColumns() {return shadow()->trailing_fixed_columns;}

  void setRow        (int row)         { shadow()->row = row; }
  void setColumn     (int column)      { shadow()->column = column; }
  void setNextRow    (int nextRow)     { shadow()->next_row = nextRow; }
  void setNextColumn (int nextColumn)  { shadow()->next_column = nextColumn; }
  void setFixedRows  (int fixedRows)   { shadow()->fixed_rows = fixedRows; }
  void setNumRows    (int numRows)     { shadow()->num_rows = numRows; }
  void setNumColumns (int numColumns)  { shadow()->num_columns = numColumns; }
  void setParam      (String param)    { shadow()->param = param; }
  void setQparam     (XrmQuark qparam) { shadow()->qparam = qparam; }

  void setFixedColumns (int fixedColumns) 
                   { shadow()->fixed_columns = fixedColumns; }
  void setLeadingFixedRows (int leadingFixedRows) 
                   { shadow()->leading_fixed_rows = leadingFixedRows; }
  void setLeadingFixedColumns (int leadingFixedColumns) 
                   { shadow()->leading_fixed_columns = leadingFixedColumns; }
  void setTrailingFixedRows (int trailingFixedRows) 
                   { shadow()->trailing_fixed_rows = trailingFixedRows; }
  void setTrailingFixedColumns (int trailingFixedColumns) 
                   { shadow()->trailing_fixed_columns = trailingFixedColumns; }

  virtual RWClassID isA() const {return __RWMATRIXTRAVERSECELLCALLBACK;}

 private:
  XbaeMatrixTraverseCellCallbackStruct * shadow()
    { return (XbaeMatrixTraverseCellCallbackStruct *) shadow_;}
};

/*
 * Struct passed to selectCellCallback
 */
class RWMatrixSelectCellCallback : public RWAnyCallback
{
 public:
  RWMatrixSelectCellCallback(XbaeMatrixSelectCellCallbackStruct * cbs)
    : RWAnyCallback ((XmAnyCallbackStruct *) cbs) {}
  ~RWMatrixSelectCellCallback() {}

  int        getRow()           { return shadow()->row; }
  int        getColumn()        { return shadow()->column; }
  String  ** getCells()         { return shadow()->cells; }
  Cardinal   getNumParams()     { return shadow()->num_params; }
  String   * getParams()        { return shadow()->params; }
  Boolean ** getSelectedCells() { return shadow()->selected_cells; }

  void setRow           (int      row)       { shadow()->row = row; }
  void setColumn        (int      column)    { shadow()->column = column; }
  void setCells         (String **cells)     { shadow()->cells = cells; }
  void setNumParams     (Cardinal numParams) { shadow()->num_params=numParams;}
  void setParams        (String * params)    { shadow()->params = params; }
  void setSelectedCells (Boolean **selectedCells) 
                                { shadow()->selected_cells = selectedCells; }

  virtual RWClassID isA() const {return __RWMATRIXSELECTCELLCALLBACK;}

 private:
  XbaeMatrixSelectCellCallbackStruct * shadow()
    { return (XbaeMatrixSelectCellCallbackStruct *) shadow_;}
};

/*
 * Struct passed to drawCellCallback
 */
class RWMatrixDrawCellCallback : public RWAnyCallback
{
 public:
  RWMatrixDrawCellCallback (XbaeMatrixDrawCellCallbackStruct * cbs)
    : RWAnyCallback ((XmAnyCallbackStruct *) cbs) {}
  ~RWMatrixDrawCellCallback() {}

  int          getRow()        { return shadow()->row; }
  int          getColumn()     { return shadow()->column; }
  int          getWidth()      { return shadow()->width; }
  int          getHeight()     { return shadow()->height; }
  XbaeCellType getType()       { return shadow()->type; }
  String       getString()     { return shadow()->string; }
  Pixmap       getPixmap()     { return shadow()->pixmap; }
  Pixel        getForeground() { return shadow()->foreground; }
  Pixel        getBackground() { return shadow()->background; }

  void setRow        (int row)           { shadow()->row = row; }
  void setColumn     (int column)        { shadow()->column = column; }
  void setWidth      (int width)         { shadow()->width = width; }
  void setHeight     (int height)        { shadow()->height = height; }
  void setType       (XbaeCellType type) { shadow()->type = type; }
  void setString     (String string)     { shadow()->string = string; }
  void setPixmap     (Pixmap pixmap)     { shadow()->pixmap = pixmap; }
  void setForeground (Pixel foreground)  { shadow()->foreground = foreground; }
  void setBackground (Pixel background)  { shadow()->background = background; }

  virtual RWClassID isA() const {return __RWMATRIXDRAWCELLCALLBACK;}

 private:
  XbaeMatrixDrawCellCallbackStruct * shadow()
    { return (XbaeMatrixDrawCellCallbackStruct *) shadow_;}
};


/*
 * Struct passed to defaultActionCallback
 */
class RWMatrixDefaultActionCallback : public RWAnyCallback
{
 public:
  RWMatrixDefaultActionCallback(XbaeMatrixDefaultActionCallbackStruct * cbs)
    : RWAnyCallback ((XmAnyCallbackStruct *) cbs) {}
  ~RWMatrixDefaultActionCallback() {}

  int getRow()    { return shadow()->row; }
  int getColumn() { return shadow()->column; }

  void setRow    (int row)    { shadow()->row = row; }
  void setColumn (int column) { shadow()->column = column; }

  virtual RWClassID isA() const {return __RWMATRIXDEFAULTACTIONCALLBACK;}

 private:
  XbaeMatrixDefaultActionCallbackStruct * shadow()
    { return (XbaeMatrixDefaultActionCallbackStruct *) shadow_;}
};


#endif  /* _RWMATRIX_H */ /* DO NOT ADD ANYTHING AFTER THIS LINE! */
