/*
 * Copyright (c) 1998, 1999, Bjorn Lindgren <bjorn@goatnet.ml.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by
 *      Bjorn Lindgren <bjorn@goatnet.ml.org>.
 * 4. Neither the name of the authors nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

static const char rcsid[] = "$Id$";

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <xwhois.h>

__BEGIN_DECLS

void get_servers __P((void));

__END_DECLS

void get_servers()
{
  FILE *fp;
  char *sp;
  char buffer[256];
  int i=0, j=0;

  /*
   * Buffer overflow checking for $HOME unnesessary.
   */

  sprintf(buffer,"%s",getenv("HOME"));
  strcat(buffer,"/.xwhois.servers");

  /*
   * Set all struct members to NULL.
   */

  for (i=0; i<256; i++)
    {
      servers[i].name = servers[i].comment = NULL;
    }
  i=0;

  /*
   * Open server file. Try user home directory first, if no
   * server file in there, try system server file path.
   */

  if (!(fp=fopen(buffer,"r")))
    {
      sprintf(buffer,"%s",XWHOIS_SERVERS);
      if (!(fp=fopen(buffer,"r")))
	{
	  printf("Could not open xwhois server file '%s'!\n", XWHOIS_SERVERS);
	  exit(1);
	}
    }

  /*
   * Read server entrys from server file descriptor.
   */

  while (fgets(buffer,255,fp))
    {
      if (!(buffer[0] == '#' || buffer[0] == '\n')) /* skip comments and empty lines */
	{
	  servers[i].name = malloc(strlen(buffer)+1);
	  sscanf(buffer,"%s",servers[i].name);

	  sp = malloc(strlen(buffer)+1);
	  sp=buffer;

	  j=0;
	  while (!(buffer[j] == '\n' || buffer[j] == '#'))
	    {
	      sp++;
	      j++;
	    }

	  if (sp[0] == '#')
	    {
	      sp++; sp++;
	      servers[i].comment = malloc(strlen(sp)+1);
	      sprintf(servers[i].comment,"%s",sp);
	    }
	  i++;
	}
    }
  fclose(fp);
}
