/* $Id: tcp.c,v 1.2 1995/10/01 20:53:59 chris Exp $ */

/* $Log: tcp.c,v $
 * Revision 1.2  1995/10/01  20:53:59  chris
 * Made some messages verbose-mode only.
 *
 * Revision 1.1  1995/10/01  18:53:17  chris
 * Initial revision
 * */

/* tcp.c  TCP communications routines */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <ctype.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>

#include "tcp.h"
#include "config.h"


static char rcsid[]="$Id: tcp.c,v 1.2 1995/10/01 20:53:59 chris Exp $";


static int timeout;


void alarmfunc(int signal)
{
  timeout=1;
}


/* Open a socket and connect to remote host on a given port. */
FILE *tcp_open_connection(char *hostname, char *prot)
{
  struct servent *service;
  struct protoent *proto;
  struct hostent *host;
  struct sockaddr_in server;
  int socknr;
  unsigned char ip[4];
  int i;
  unsigned char *c;
  FILE *f;

  proto=getprotobyname("tcp");
  if (!proto) return NULL;	/* no such protocol */
  socknr=socket(AF_INET,SOCK_STREAM,proto->p_proto);
  if (socknr==-1) return NULL; /* no socket available */
  /* We have a socket on our machine; now let's find out how to
     connect to the remote host */
  if (isdigit(*hostname)) {
    /* We are given a string with four decimal numbers, separated
       by dots */
    c=hostname;
    for (i=0; i<4; i++) {
      ip[i]=0;
      if (!*c) return NULL;	/* bad hostname */
      while (*c!='.'&&*c) {
	ip[i]=ip[i]*10+(*c&15);
	c++;
      }
      if (*c=='.') c++;
    }
    host=(struct hostent *)gethostbyaddr(ip,4,AF_INET);
  }
  else	{
    /* it's a real hostname */
    host=(struct hostent *)gethostbyname(hostname);
  }
  if (!host) return NULL;	/* unknown host */
  bcopy(host->h_addr,ip,4);	
  service=getservbyname(prot,"tcp");
  if (!service) return NULL;	 /* illegal service */
  bzero((char *)&server,sizeof(server));
  bcopy(host->h_addr,(char *)&server.sin_addr,host->h_length);
  server.sin_family=host->h_addrtype;
  server.sin_port=service->s_port;	/* note that this is high-byte first!! */
  /* OK, now let's connect! */
  timeout=0;
  signal(SIGALRM,alarmfunc);
  alarm(TIMEOUT);
  if (connect(socknr,(void *)&server,sizeof(server))==-1 || timeout) {
    alarm(0);
    return NULL;	/* connection refused */
  }
  alarm(0);
  f=fdopen(socknr,"w+b");
  if (!f) return NULL;
#ifdef SETVBUF
  setvbuf(f,NULL,_IOLBF,BUFSIZ); /* make sure sockets are line buffered */
#endif
  return f;
}


/* This function closes a connection on a given socket for both rx and tx.
Returns 0 on success, -1 on error */
int tcp_close_connection(FILE *f)
{
  fflush(f);
  return shutdown(fileno(f),2);
}


static char timeoutflag;

void sigalarm(int signal)
{
  timeoutflag=1;
}


int tcp_read_line(FILE *f, char *line, int maxsize, long timeout)
{
  signal(SIGALRM,sigalarm);
  timeoutflag=0;
  line[0]=0;
  alarm(timeout);
#ifndef SCUMOS
  fgets(line,maxsize,f);
#else
  {
    int fn;
    char *c=line;
    fn=fileno(f);
    while (1) {
      if (timeoutflag) break;
      if (!read(fn,c,1)) {sleep(1); continue;}
      if (*c=='\n') {
	*(++c)=0;
	break;
      }
      c++;
    }
  }
#endif
#ifdef DEBUG
  printf("<%s",line);
#endif
  alarm(0);
  if (timeoutflag) return 0;
  return strlen(line);
}

