/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#include <config.h>

#include <stdarg.h>
#include <stdio.h>
#include "debug.h"
#include "util.h"

static gulong debug_level = 0;

extern void set_debug_level (gulong level)
{
	debug_level = level;
}

extern void debug (gulong flag, const gchar* fmt, ...)
{
	g_return_if_fail (fmt != NULL);

	if (flag & debug_level)
	{
        	va_list args;
		gchar *string;
		const gchar* prefix = NULL;

		/* get prefix */
		if (flag&DEBUG_QUEUE) prefix="QUEUE";
		else if (flag&DEBUG_SOCKET_INPUT) prefix="SOCKET INPUT";
		else if (flag&DEBUG_SOCKET_OUTPUT) prefix="SOCKET OUTPUT";
		else if (flag&DEBUG_DECODE) prefix="DECODE";
		else if (flag&DEBUG_ACACHE) prefix="ACACHE";
		else if (flag&DEBUG_LOCK) prefix="LOCK";
		else if (flag&DEBUG_DB) prefix="DATABASE";
		else if (flag&DEBUG_PAN_OBJECT) prefix="PAN OBJECT";
		else {pan_warn_if_reached(); prefix="FOO";}

		va_start (args, fmt);
		string = g_strdup_vprintf (fmt, args);
		va_end (args);

		g_message ("%s: %s", prefix, string);
		g_free (string);
	}
}

