/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __GROUPS_H__
#define __GROUPS_H__

#include <glib.h>
#include "server.h"

enum {
        STATE_FILTER_UNREAD                     = (1<<0),
        STATE_FILTER_READ                       = (1<<1),
        STATE_FILTER_WATCHED                    = (1<<2),
        STATE_FILTER_KILLFILE                   = (1<<3),
        STATE_FILTER_NORMAL_RANK                = (1<<4),
        STATE_FILTER_COMPLETE_BINARIES          = (1<<5),
        STATE_FILTER_INCOMPLETE_BINARIES        = (1<<6),
        STATE_FILTER_NONBINARIES                = (1<<7),
        STATE_FILTER_SAVED                      = (1<<8),
        STATE_FILTER_QUEUED                     = (1<<9),
        STATE_FILTER_IDLE                       = (1<<10)
};

typedef struct
{
	gchar*  name;		/* alt.what.is.my.name */
	gchar*  description;	/* xgtitle */
	gint    flags;		/* new, subscribed */
	guint	state_filter;	/* for filtering articles */
}
group_data;

extern int compare_group_data_std (const void*, const void*);
extern gint compare_group_data (group_data *, group_data *);
extern void check_new_group_list_for_newness ( GSList* list );
extern void choose_download_dialog (const server_data*, group_data *);
extern void group_free			(group_data *gdata);
extern void get_all_groups		(void);
extern void get_new_groups		(void);
extern void group_empty (server_data *sdata, group_data *gdata);
extern void group_empty_dialog (group_data *gdata);
extern void group_unload (group_data *gdata);
extern group_data* group_copy (const group_data *src);
extern group_data* group_new (void);

//=============

extern void add_group_to_clist (server_data *sdata, group_data *gdata);
extern void add_group_to_clist_if_match(server_data *sdata, group_data*, gint flag_mask); 
extern void add_group_to_clist_if_match_gfunc(server_data *sdata, gpointer, gpointer);

//=============

extern int group_get_attrib_i	(const server_data*, const group_data *, const char *);
extern void group_set_attrib_i	(const server_data*, const group_data *, const char *, int);
extern void group_add_attrib_i (const server_data*, const group_data *, const char *, int);
extern void group_set_attrib_string (const server_data*, const group_data *gdata, const char *attrib, const char *value);
extern gchar* group_get_attrib_string (const server_data*, const group_data *gdata, const char *attrib);

//=============


#endif /* __GROUPS_H__ */
