/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __GROUPLIST_H__
#define __GROUPLIST_H__

#include <glib.h>
#include <gtk/gtkwidget.h>

#include "group.h"
#include "server.h"

enum {
	GROUP_ALL				= (1<<0),
	GROUP_SUBSCRIBED			= (1<<1),
	GROUP_NEW				= (1<<2)
};

extern void grouplist_prev_group (void);
extern void grouplist_prev_unread_group (void);
extern void grouplist_next_group (void);
extern void grouplist_next_unread_group (void);

extern int  grouplist_get_view_mode (void);
extern void grouplist_set_view_mode (GtkWidget *widget, gpointer data);

extern void grouplist_save_index (server_data *sdata);
extern void grouplist_save_selected	(server_data*);
extern void grouplist_save		(server_data*);
extern void grouplist_save_group	(server_data*, group_data*);

extern void grouplist_update_ui (server_data *sdata);
extern void grouplist_update_row	(const group_data *gdata);
extern void grouplist_process_selcted	(int type);
extern void grouplist_selected_download_all (void);
extern void grouplist_selected_download_new (void);
extern void grouplist_selected_subscribe   (void);
extern void grouplist_selected_unsubscribe (void);
extern void grouplist_selected_properties (void);
extern void grouplist_selected_unnew	(void);
extern void grouplist_selected_empty	(void);
extern void grouplist_all_subscribed_download_new (void);
extern void grouplist_all_subscribed_download_all (void);
extern void grouplist_load		(server_data *);
extern GtkWidget* grouplist_create	(void);
extern void grouplist_free		(GSList *);
extern void grouplist_select_all	(void);
extern void grouplist_get_all	(void);
extern void grouplist_get_new	(void);
extern void grouplist_server_selected (server_data *sdata);

extern server_data *grouplist_get_current_server (void);

/* must call g_slist_free when done */
extern GSList* grouplist_get_selected_groups (void);

#endif /* __GROUPLIST_H__ */
