/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __MESSAGE_FILTER_H__
#define __MESSAGE_FILTER_H__

extern void message_filter_ui ( void );

typedef enum
{
	MESSAGE_FILTER_ACTION_NONE,
	MESSAGE_FILTER_ACTION_KILL,
	MESSAGE_FILTER_ACTION_WATCH
}
MessageFilterAction;

extern MessageFilterAction message_filter_get_action (
	const group_data*,
	const article_data* );

extern void message_filter_killfile_add (
	const char* author_str,
	const char* subject_str,
	const char* group_str,
	const char* thread_str,
	int crosspost_qty,
	int duration_days,
	MessageFilterAction action);

#endif /* __MESSAGE_FILTER_H__ */
