/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __MESSAGE_SEND_H__
#define __MESSAGE_SEND_H__

#include <gtk/gtkwidget.h>
#include "message.h"
#include "sockets.h"
#include "status-item.h"

extern void send_cb (GtkWidget *widget, Message *msg);

enum MessageSendResult
{
	SMTP_FAILED	= (1<<0),
	NNTP_FAILED	= (1<<1)
};

/**
 * @param StatusItem the item to which status/errors are emitted
 * @param sock the nntp socket to which nntp posts are sent
 * @param message the message to be posted/mailed
 * @return an or'ed list of MessageSendResult fields, or 0 on complete success
 *
 * FIXME: maybe it would be better to decouple email and nntp sends?  Ask Jason
 */
extern gint message_send (StatusItem*, PanSocket *sock, Message *msg);

#endif
