/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#include <config.h>

#include <glib.h>

#include "debug.h"
#include "pan-object.h"

static int obj_count = 0;

void
pan_object_destroy (PanObject* o)
{
	debug (DEBUG_PAN_OBJECT, "pan_object_destroy: %p", o, obj_count);
	g_return_if_fail (o!=NULL);
	if (o->ref_count)
		g_warning ("Destroying a PanObject with a refcount of %d", o->ref_count);
	(*o->destructor)(o);
	g_free (o);
}

void
pan_object_sink (PanObject* o)
{
	debug (DEBUG_PAN_OBJECT, "pan_object_sink: %p ref %d", o, o->ref_count);
}

void
pan_object_ref (PanObject* o)
{
	g_return_if_fail (o!=NULL);
	++o->ref_count;
	debug (DEBUG_PAN_OBJECT, "pan_object_ref: %p up to %d", o, o->ref_count);
}
void
pan_object_unref (PanObject* o)
{
	g_return_if_fail (o!=NULL);
	--o->ref_count;
	debug (DEBUG_PAN_OBJECT, "pan_object_unref: %p down to %d", o, o->ref_count);
	if (o->ref_count<1)
		pan_object_destroy (o);
}

/**
***
**/


PanObject*
pan_object_new (void)
{
	PanObject* o = g_new0 (PanObject, 1);
	debug (DEBUG_PAN_OBJECT, "pan_object_new: %p", o);
	pan_object_constructor (o, pan_object_destructor);
	return o;
}
void
pan_object_constructor (PanObject* o, PanObjectDestructor destructor)
{
	++obj_count;
	debug (DEBUG_PAN_OBJECT, "pan_object_constructor: %p (%d pan_objects are alive)", o, obj_count);
	g_return_if_fail (o!=NULL);
	o->ref_count = 1;
	o->destructor = destructor;
}
void
pan_object_destructor (PanObject *o)
{
	--obj_count;
	debug (DEBUG_PAN_OBJECT, "pan_object_destructor: %p (%d pan_objects are alive)", o, obj_count);
	g_return_if_fail (o!=NULL);
}

gpointer
pan_object_get_user_data (const PanObject* o)
{
	return o->user_data;
}

void
pan_object_set_user_data (PanObject* o, gpointer user_data)
{
	o->user_data = user_data;
}
