/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __STATS_H__
#define __STATS_H__

typedef struct _PanStatistics PanStatistics;
struct _PanStatistics {
	gulong bytes_received;
	gulong bytes_sent;
	gulong time_online;

	gfloat transfer_rate;
};

typedef struct _PanStatsWindow PanStatsWindow;
struct _PanStatsWindow {
	GtkWidget *dialog;

	GtkWidget *bytes_rec;
	GtkWidget *bytes_sent;
	GtkWidget *time_online;
};


extern PanStatistics pan_stats;
extern PanStatsWindow psw;

/*  function prototypes  */
void stats_init (PanStatistics stats);
void stats_window_spawn (void);
gchar* stats_make_time_online_string (void);
void stats_window_init (void);


#endif /* __STATS_H__ */
