#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <unistd.h>

#include <gtk/gtk.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

void NP_Collections::disable_callbacks( GtkWidget *win_p, int i )
{
   static GdkCursor *normal, *wait;

   if ( i )
   {
      signal( SIGUSR1, SIG_IGN );
      signal( SIGUSR2, SIG_IGN );

      normal = gdk_cursor_new(  GDK_TOP_LEFT_ARROW );
      wait = gdk_cursor_new( GDK_WATCH );
      gdk_window_set_cursor( win_p->window, wait );
      gtk_widget_draw( win_p, NULL );
   
      callbacks_disabled = 1;
   }
   else
   {
      signal( SIGUSR2, SIGUSR2_handler );
      signal( SIGUSR1, SIGUSR1_handler );

      gdk_window_set_cursor( win_p->window, normal );
      gtk_widget_draw( win_p, NULL );
      gdk_cursor_destroy( normal );
      gdk_cursor_destroy( wait );

      callbacks_disabled = 0;
   }

   return;
}
