#include <stdlib.h>
#include <stdio.h>

#include <gtk/gtk.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

void search_clist_callback( GtkWidget *widget, gint row, gint col,
                            GdkEvent *event, gpointer data )
{
   NP_Collections *collections = ( NP_Collections *)data;

   if ( !collections->total_nodes )
      return;
   
   int total = collections->search_results.get_total();
   if ( total < 0 )
   {
      collections->search_results.print_error();
      return;
   }

   if ( !total )
      return;

   char *server, *group, *article, *line;

   gtk_clist_get_text( GTK_CLIST( collections->search_clist ), row, 0,
                       &server );
   gtk_clist_get_text( GTK_CLIST( collections->search_clist ), row, 1,
                       &group );
   gtk_clist_get_text( GTK_CLIST( collections->search_clist ), row, 2,
                       &article );
   gtk_clist_get_text( GTK_CLIST( collections->search_clist ), row, 3,
                       &line );

   int i = collections->tree[ server ];
   if ( i < 0 )
   {
      collections->tree.print_error();
      return;
   }
   
   int j = collections->tree.get_group_index( server, group );
   if ( j < 0 )
   {
      collections->tree.print_error();
      return;
   }

   gtk_tree_item_expand( GTK_TREE_ITEM( collections->tree_nodes[ i ].node ));

   collections->search_position = atoi( article );
   collections->search_line = atoi( line );
   collections->button = 1;
   
   if ( collections->selected_item !=
        collections->tree_nodes[ i ].group_nodes[ j ] )
      gtk_tree_select_child( GTK_TREE( collections->tree_widget ),
                             collections->tree_nodes[ i ].group_nodes[ j ] );
   else
      tree_callback( collections->tree_widget, data );

   collections->button = 0;
   collections->search_position = -1;

   return;
}
