#include "npconfig.h"

void dialog_add_callback( GtkWidget *widget, gpointer data )
{
   int i = ( int)gtk_object_get_data( GTK_OBJECT( widget ), "button" );

   GtkWidget *entry = ( GtkWidget *)data;
   
   GtkWidget *window =
      ( GtkWidget *)gtk_object_get_data( GTK_OBJECT( entry ), "window" );

   GtkWidget *outer_box =
      ( GtkWidget *)gtk_object_get_data( GTK_OBJECT( entry ), "box" );
   
   NP_Config *config =
      ( NP_Config *)gtk_object_get_data( GTK_OBJECT( entry ), "config" );

   int total = 0;
   char *server = NULL;
   
   if ( i )
   {
      server = gtk_entry_get_text( GTK_ENTRY( entry ));
      if ( server != NULL && *server != '\0' )
      {
         int result;
         if (( result = config->subscription.add_server( server, 1 )))
         {
            if ( result == 2 )
               config->show_message( "You may not create duplicate server "
                                     "entries.", 0 );
            else
               config->subscription.print_error();
            return;
         }

         config->dirty = 1;

         int total = config->deleted.get_total();
         if ( total < 0 )
            config->deleted.print_error();
         else
            if ( total )
               for( int i = 0; i < total; ++i )
               {
                  char *match = ( char *)config->deleted[ i ];

                  if ( match == NULL )
                  {
                     config->deleted.print_error();
                     break;
                  }
                  else
                     if ( !strcmp( server, strchr( match, '-' ) + 1 ))
                     {
                        if ( config->deleted.remove_item( match ))
                        {
                           config->deleted.print_error();
                           break;
                        }
                  
                        total = config->deleted.get_total();
                        if ( total < 0 )
                        {
                           config->deleted.print_error();
                           break;
                        }
                     }
               }

         total = config->subscription.get_total();
         if (( config->server_frames =
               ( GtkWidget **)realloc( config->server_frames,
                                       total * sizeof *config->server_frames ))
             == NULL )
         {
            perror( "realloc" );
            exit( 1 );
         }

         if (( config->server_buttons =
               ( GtkWidget **)realloc( config->server_buttons, total *
                                       sizeof *config->server_buttons ))
             == NULL )
         {
            perror( "realloc" );
            exit( 1 );
         }

         /*
          * Get the const char pointer value for server back out of the
          * subscription object. If we pass the local value retrieved
          * from the entry, it will be destroyed when the entry's value
          * changes, and address_buttons_callback will get gibberish for
          * its data argument. 
          */
         
         server = ( char *)config->subscription[ total - 1 ];
         config->create_server_frame( outer_box, total - 1,
                                      ( const char *)server );
         config->create_server_button( total - 1, server );
      }
   }

   gtk_grab_remove( window );
   gtk_widget_destroy( window );

   if ( total == 1 )
   {
      GTK_TOGGLE_BUTTON( config->server_buttons[ 0 ] )->active = TRUE;
      address_buttons_callback( config->server_buttons[ 0 ], server );
   }
   
   return;
}
