#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

#include "npserver.h"

int NP_Server::get_newgroups( char *name )
{
   FILE *stamp_file, *list_file;
   char buffer[ 1024 ], timestamp[ 64 ];
   unsigned int count;

   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/%s-LIST", 
             home, name );
   if (( list_file = fopen( buffer, "a" )) == NULL )
   {
      snprintf( error_message, sizeof error_message,
                "NP_Server: get_newgroups(): fopen() returned error: %s.",
                strerror( errno ));
      return 1;
   }

   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/%s-TIMESTAMP", 
             home, name );
   if (( stamp_file = fopen( buffer, "r" )) == NULL )
   {
      fclose( list_file );

      if ( errno == ENOENT )
      {
         snprintf( error_message, sizeof error_message,
                   "NP_Server: get_newgroups(): no timestamp file for %s.",
                   buffer );
         return 3;
      }
      else
      {
         snprintf( error_message, sizeof error_message,
                   "NP_Server: get_newgroups(): fopen() returned error: %s.",
                   strerror( errno ));
         return 1;
      }
   }
   
   if ( fgets( timestamp, 64, stamp_file ) == NULL )
   {
      snprintf( error_message, sizeof error_message,
                "NP_Server: get_newgroups(): empty timestamp file for %s.",
                name );
      fclose( list_file );
      return 1;
   }

   snprintf( buffer, sizeof buffer,
             "newgroups %s GMT\r\n", strtok( timestamp, "\n" ));
   np_fputs( buffer );
   
   if ( np_fgets( buffer, sizeof buffer ))
   {
      fclose( list_file );
      return -1;
   }

   if ( strncmp( buffer, "231", 3 ))
   {
      snprintf( error_message, sizeof error_message,
                "NP_Server: get_newgroups(): server response: %s.",
                buffer );
      fclose( list_file );
      return 1;
   }

   count = 0;

   for( ; ; )
   {
      if ( np_fgets( buffer, sizeof buffer ))
      {
         fclose( list_file );
         return 1;
      }

      if ( !strncmp( buffer, ".\r\n", 3 ))
         break;

      if ( !strncmp( buffer, "junk", 4 ) ||
           !strncmp( buffer, "control", 7 ))
         continue;

      ++count;

      if ( busy_callback != NULL )
         if ( busy_callback( busy_callback_data, -1, count ))
            break;

      fprintf( list_file, "%s", strtok( buffer, " " ));
      strtok( NULL, " " );
      long x = atol( strtok( NULL, " " ));
      fprintf( list_file, ": %ld\n", x );
   }

   fclose( list_file );

   if ( write_timestamp( name ))
      return 1;

   if ( !count )
      return 2;

   return 0;
}
