#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>

#include "npserver.h"

int NP_Server::np_fputs( char *line )
{
   int result, size;

   if ( !( size = strlen( line )))
   {
      strcpy( error_message, "NP_Server: np_fputs(): empty line passed "
              "as argument." );
      return 1;
   }
   
   if (( result = write( fd, line, size )) < 0 )
   {
      np_fputs_error();
      return 1;
   }

   char *pointer = line;
   int total = result;

   while( total < size )
   {
      if ( wait_for_activity( 1 ))
         return 1;

      pointer += result;

      if (( result = write( fd, pointer, size - total )) < 0 )
      {
         np_fputs_error();
         return 1;
      }

      total += result;
   }

   return 0;
}
