#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

#include "npserver.h"

int NP_Server::np_read( char *character )
{
   static int count = 0;
   static char buffer[ 16536 ], *pointer;

   while( count <= 0 )
   {
      if ( wait_for_activity( 0 ))
         return -1;

      if (( count = read( fd, buffer, sizeof buffer )) < 0 )
         if ( errno == EINTR )
            continue;
         else
         {
            snprintf( error_message, sizeof error_message, "NP_Server: "
                      "np_read(): read(): %s", strerror( errno ));
            return -1;
         }

      if ( !count )
         break;
      
      pointer = buffer;
   }
   
   if ( !count )
      return 1;

   *character = *pointer++;
   --count;

   return 0;
}

   
   
      
   
