#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>

#include "npserver.h"

int NP_Server::wait_for_activity( int mode )
{
   static struct timeval tval;
   static fd_set rset, wset;

   int result, error, counter;

   seconds = timeout;
   counter = -1;
   
   do
   {
      /*
       * Check for timeout.
       */

      if ( ++counter == 4 )
      {
         counter = 0;
         if ( !( --seconds ))
         {
            snprintf( error_message, sizeof error_message,
                      "NP_Server: wait_for_activity():"
                    " timed-out after %d seconds.", timeout );
            return 1;
         }
      }

      /*
       * Run busy callback; check for user interrupt.
       */
      
      if ( busy_callback != NULL )
         if ( busy_callback( busy_callback_data, seconds, -1 ))
         {
            strcpy( error_message, "NP_Server: wait_for_activity(): "
                    "function execution cancelled by busy_callback()." );
            return 1;
         }
      
      FD_ZERO( &rset );
      wset = rset;
      
      switch( mode )
      {
      case 0:
         FD_SET( fd, &rset );
         break;

      case 1:
         FD_SET( fd, &wset );
         break;

      case 2:
         FD_SET( fd, &rset );
         wset = rset;
         break;
      }

      tval.tv_sec = 0;
      tval.tv_usec = 250000;

   }
   while( !( result = select( fd + 1, &rset, &wset, NULL, &tval )));

   if ( result < 0 )
   {
      snprintf( error_message, sizeof error_message,
                "NP_Server: wait_for_activity(): "
                "select() returned error: %s", strerror( errno ));
      return 1;
   }

   /*
    * Are there any errors pending on the socket itself?
    */

   if ( FD_ISSET( fd, &rset ) || FD_ISSET( fd, &wset ))
   {
      unsigned int len = sizeof error;

      if ( getsockopt( fd, SOL_SOCKET, SO_ERROR, &error, &len ) < 0 )
      {
         strcpy( error_message, "NP_Server: wait_for_activity(): "
                 "an error exists for the socket." );
         return 1;
      }
   }
   
   return 0;
}
