#include <stdlib.h>
#include <stdio.h>
#include <regex.h>
#include <string.h>

#include "npfile.h"
#include "npstringarray.h"
#include "nppex.h"

void NP_Pex::convert_zone( char *buffer )
{
   char *zone;

   if ( buffer[ 0 ] == '+' || buffer[ 0 ] == '-' )
   {
      buffer[ 5 ] = buffer[ 4 ];
      buffer[ 4 ] = buffer[ 3 ];
      buffer[ 3 ] = buffer[ 0 ] = (( buffer[ 0 ] == '+' ) ? '-' : '+' );
      buffer[ 6 ] = '\0';
      return;
   }
   else
      switch( buffer[ 0 ] )
      {
      case 'C':
         switch( buffer[ 1 ] )
         {
         case 'D':
            zone = "-06-00";
            break;

         default:
            zone = "-07-00";
            break;
         }

         break;

      case 'E':
         switch( buffer[ 1 ] )
         {
         case 'D':
            zone = "-00-00";
            break;

         default:
            zone = "-06-00";
            break;
         }

         break;

      case 'G':
         zone = "+00+00";
         break;

      case 'M':
         switch( buffer[ 1 ] )
         {
         case 'D':
            zone = "-07-00";
            break;

         default:
            zone = "-08-00";
            break;
         }

         break;

      case 'P':
         switch( buffer[ 1 ] )
         {
         case 'D':
            zone = "-08-00";
            break;

         default:
            zone = "-09-00";
            break;
         }
         break;

      default:
         zone = "unknown";
         break;
      }

   strcpy( buffer, zone );

   return;
}

                                     

