#include <stdlib.h>
#include <stdio.h>
#include <regex.h>
#include <string.h>
#include <errno.h>

#include "npfile.h"
#include "npsearch.h"

int NP_Search::search_group( char *server, char *group, int requests )
{
   if ( !compiled )
   {
      strcpy( error_message, "NP_Search: search_group(): no regular "
              "expression has been compiled." );
      return 1;
   }

   if ( server == NULL )
   {
      strcpy( error_message, "NP_Search: search_group(): NULL server address"
              " passed as argument." );
      return 1;
   }

   if ( group == NULL )
   {
      strcpy( error_message, "NP_Search: search_group(): NULL group name"
              " passed as argument." );
      return 1;
   }
      
   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/%s-%s",
             home, server, group );
   if ( file.openr( buffer ))
   {
      if ( errno != ENOENT )
      {
         snprintf( error_message, sizeof error_message, "NP_Search: "
                   "search_group(): %s", file.get_error());
         return 1;
      }

      return 0;
   }
   
   int article = 1, lineno = 1, first = 1;
   char *line;

   while(( line = file.get_string()) != NULL )
   {
      if ( first && *line == '@' )
      {
         first = 0;
         continue;
      }

      if ( !strncmp( line, ".\r\n", 3 ))
      {
         ++article;
         lineno = 1;
         first = 1;
         continue;
      }

      int result = regexec( &regex, line, 0, NULL, 0 );
      if ( result )
         if ( result == REG_NOMATCH )
         {
            ++lineno;
            continue;
         }
         else
         {
            strcpy( error_message, "NP_Search: search_group(): " );
            regerror( result, &regex, buffer, sizeof buffer );
            strcat( error_message, buffer );
            file.close();
            return 1;
         }

      printf( "%s:%s:%d:%d:%s\n", server, group, article, lineno++,
              strtok( line, "\r\n" ));
   }

   file.close();
   
   return 0;
}
