#include <signal.h>
#include <unistd.h>
#include <string.h>

#include "npsummary.h"

void folders_clist_callback( GtkWidget *widget, gint row, gint col,
                             GdkEvent *event, gpointer data )
{
   NP_Summary *summary = ( NP_Summary *)data;

   summary->folder_selection = row;

   return;
}

void folders_callback( GtkWidget *widget, gpointer data )
{
   NP_Summary *summary = ( NP_Summary *)data;

   int i = ( int)gtk_object_get_data( GTK_OBJECT( widget ), "ok" );
   
   if ( !i )
   {
      gtk_widget_destroy( summary->folders_window );
      summary->folders_window = NULL;
      return;
   }
   
   if ( summary->folder_selection == -1 )
   {
      summary->show_message( "You have not selected a folder in the list." );
      return;
   }

   char *text, buffer[ 1024 ];
   gtk_clist_get_text( GTK_CLIST( summary->folders_clist ),
                       summary->folder_selection, 0, &text );

   if ( !strcmp( summary->server, "Folders" ))
      if ( !strcmp( text, summary->group ))
      {
         snprintf( buffer, sizeof buffer, "The message is already in %s",
                   text );
         summary->show_message( buffer );
         return;
      }

   NP_File spool, read, folder;

   char *home;
   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/Folders-%s",
             home = getenv( "HOME" ), text );
   
   if ( folder.opena( buffer ))
   {
      summary->show_message( folder.get_error() );
      return;
   }

   strcat( buffer, ":read" );
   if ( read.opena( buffer ))
   {
      summary->show_message( read.get_error());
      return;
   }

   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/%s-%s", home,
             summary->server, summary->group );
   if ( spool.openr( buffer ))
   {
      summary->show_message( spool.get_error() );
      return;
   }

   if ( spool.seek( summary->current_node->offset, SEEK_SET ))
   {
      summary->show_message( spool.get_error() );
      return;
   }

   char *line;
   
   do
   {
      if (( line = spool.get_string()) == NULL )
         break;

      if ( folder.put_string( line ))
      {
         summary->show_message( folder.get_error() );
         return;
      }
   }
   while( strncmp( line, ".\r\n", 3 ));

   folder.close();
   spool.close();

   read.put_string( "u\n" );
   read.close();

   if ( !summary->is_stdout_a_tty )
   {
      printf( "Folders\n%s\na\n.", text );
      fflush( stdout );
   }

   gtk_widget_destroy( summary->folders_window );
   
   return;
}
