#include "npsummary.h"

np_thread_node_t *left_button_callback( GtkWidget *widget, gpointer data )
{
   NP_Summary *summary = ( NP_Summary *)data;

   if ( !summary->total || summary->tree == NULL )
      return NULL;

   if ( summary->current_node == NULL || summary->selected_item == NULL )
   {
      gtk_tree_select_child( GTK_TREE( summary->tree_widget ),
                             GTK_WIDGET( summary->tree->item ));
   }

   summary->button = 1;

   np_thread_node_t *pointer;
   int parent = 0;

   if ( summary->current_node->child_prev != NULL )
      pointer = summary->current_node->child_prev;
   else
      if ( summary->current_node->parent != NULL )
      {
         pointer = summary->current_node->parent;
         parent = 1;
      }
      else
         if ( summary->current_node->prev != NULL )
         {
            for( pointer = summary->current_node->prev;
                 pointer != NULL;
                 pointer = pointer->prev )
               if ( !pointer->is_child && pointer->item != NULL )
                  break;
         }
         else
            pointer = NULL;

   if ( pointer == NULL )
   {
      summary->button = 0;
      return NULL;
   }

   if ( !parent && pointer->child_count && pointer->item != NULL )
   {
      if ( widget != NULL )
         gtk_tree_item_expand( GTK_TREE_ITEM( pointer->item ));

      while(( pointer->child_tail ) != NULL )
      {
         pointer = pointer->child_tail;
         gtk_tree_item_expand( GTK_TREE_ITEM( pointer->item ));
      }
   }

   if ( widget != NULL && pointer->item != NULL )
      gtk_tree_select_child( GTK_TREE( summary->tree_widget ),
                             GTK_WIDGET( pointer->item ));

   summary->button = 0;

   return pointer;
}
