#include "npsummary.h"

void NP_Summary::write_read_file()
{
   if ( !total || tree == NULL )
      return;

   if ( !strcmp( group, "FOLLOW-UPS" ) ||
        !strcmp( group, "POSTED" ) ||
        !strcmp( group, "OUTBOX" ) ||
        !strcmp( group, "SENT-MAIL" ))
      return;

   NP_File read;
   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/%s-%s:read",
             getenv( "HOME" ), server, group );

   if ( read.openw( buffer ))
   {
      read.print_error();
      return;
   }

   np_thread_node_t *old_tree = tree;
   np_thread_node_t *old_spool_beginning = spool_beginning;

   if ( hide_seen || hide_headers )
   {
      if (( tree = threads.get_tree( server, group, 0, 0, 0 )) == NULL )
         return;

      if (( spool_beginning = threads.get_spool_beginning()) == NULL )
         return;

      for( np_thread_node_t *outer_pointer = old_tree;
            outer_pointer != NULL;
            outer_pointer = outer_pointer->next )
      {
         if ( outer_pointer->is_article < 0 )
            continue;

         if ( outer_pointer->message_id == NULL )
            continue;

         for( np_thread_node_t *pointer = tree;
               pointer != NULL;
               pointer = pointer->next )
         {
            if ( pointer->is_article < 0 )
               continue;

            if ( pointer->message_id == NULL )
               continue;

            if( strcmp( pointer->message_id, 
                        outer_pointer->message_id ))
               continue;

            pointer->is_unseen = outer_pointer->is_unseen;
            pointer->is_requested = outer_pointer->is_requested;
            break;
         }
      }
   }

   for( np_thread_node_t *pointer = spool_beginning;
         pointer != NULL;
         pointer = pointer->spool_next )
   {
      snprintf( buffer, sizeof buffer, "%c\n",
            (( pointer->is_unseen == 1 ) ? 'u' : 'r' ));

      if ( read.put_string( buffer ))
      {
         read.print_error();
         return;
      }
   }

   read.close();

   write_requests_file();

   if ( hide_seen || hide_headers )
   {
      threads.clear();
      spool_beginning = old_spool_beginning;
      tree = old_tree;
      threads.assign( old_tree );
   }

   return;
}
