#include <signal.h>
#include <stdlib.h>
#include <stdio.h>

#include "npfile.h"
#include "nptext.h"

extern void *text_p;

void SIGUSR2_handler( int signo )
{
   static int running = 0;

   if ( running )
      return;
   else
      running = 1;

   NP_Text *text = ( NP_Text *)text_p;

   char buffer[ 1024 ];
   NP_File file;
   snprintf( buffer, sizeof buffer,
             "%s/.peruser_spool/.current_article_origin", text->home );
   if ( file.openw( buffer ))
   {
      file.print_error();
      return;
   }

   snprintf( buffer, sizeof buffer, "%s\n%s\n%d\n%d\n", text->server,
             text->group, text->offset, text->size );
   if ( file.put_string( buffer ))
      file.print_error();

   file.close();

   running = 0;

   signal( SIGUSR2, SIGUSR2_handler );

   return;
}
