#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

#include "npnews.h"

int NP_News::get_folder_requests_list()
{
   total_requests = 0;

   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/%s-%s:requests",
         home, address, group );
   NP_File requests;
   if ( requests.openr( buffer ))
   {
      if ( errno == ENOENT )
         return 0;

      snprintf( error_message, sizeof error_message, "NP_News: "
            "get_requests_list(): %s", requests.get_error());
      return 1;
   }

   char *line;
   while(( line = requests.get_string()) != NULL )
      if ( *line == '\n' )
         continue;
      else
         ++total_requests;

   if ( !total_requests )
      return 0;

   if (( requests_list = 
            ( np_requests_list_t *)calloc( total_requests,
                                           sizeof *requests_list ))
         == NULL )
   {
      perror( "calloc" );
      exit( 1 );
   }

   requests.seek( 0, SEEK_SET );

   np_requests_list_t *pointer = requests_list;
   for( int i = 0; i < total_requests; ++i )
   {
      pointer->found = 0;

      if (( line = requests.get_string()) == NULL )
      {
         snprintf( error_message, sizeof error_message, "NP_News: "
                   "get_folder_requests_list(): %s", requests.get_error());
         return 1;
      }

      line = strtok( line, ":" );
      if (( pointer->request = strdup( line )) == NULL )
      {
         perror( "strdup" );
         exit( 1 );
      }

      line = strtok( NULL, ":" );
      if (( pointer->server = strdup( line )) == NULL )
      {
         perror( "strdup" );
         exit( 1 );
      }

      line = strtok( NULL, "\n" );
      if (( pointer->group = strdup( line )) == NULL )
      {
         perror( "strdup" );
         exit( 1 );
      }

      ++pointer;
   }

   requests.close();

   return 0;
}
