/* The Type of Track representing a raw cd track coming directly from cdrom */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "tracks.h"
#include "datatrack.h"
#include "cddrives.h"
#include "cdromlow.h"

int datatrack_openpipe(void*trackinfo)
{	
	datatrack_info *i;
	
	i=(datatrack_info*)((tracks_trackinfo*)trackinfo)->data;

	if (i->filedes==-1)
	  {
	     i->filedes=open((char*)&i->device,O_RDONLY);
	     if (i->filedes==-1)
		      perror ("error opening data track");
	     else
	       cddrives_updatedisable();
	  }
	;
	return i->filedes;
}
;

void datatrack_closepipe(void*trackinfo)
{
	datatrack_info *i;
	
	i=(datatrack_info*)((tracks_trackinfo*)trackinfo)->data;
	if (i->filedes!=-1)
	  {		  
	     close(i->filedes);
	     i->filedes=-1;
	     cddrives_updateenable();
	  }
	;
	
}
;

int datatrack_tracksize(void*trackinfo)
{
	datatrack_info *i;
	
	i=(datatrack_info*)((tracks_trackinfo*)trackinfo)->data;
	
	return i->tracksize;
}
;

int datatrack_dataavail(void*trackinfo)
{
	datatrack_info *i;

	i=(datatrack_info*)((tracks_trackinfo*)trackinfo)->data;

	return (i->filedes!=-1);
}
;	

/* FIXME: add function tracks_invalidate() to tracks.h to regulate
 * the availability of the tracks located on a cdrom */
int  datatrack_valid(void*trackinfo)  /* isotrack is always valid */
{
	return 1;
}
;

void datatrack_destroy(void*trackinfo)
{
	datatrack_info *i;
	
	i=(datatrack_info*)((tracks_trackinfo*)trackinfo)->data;
	
	if (datatrack_dataavail(trackinfo))
	    close (i->filedes);
	free(i);
}
;

tracks_trackinfo *datatrack_create(char *device)
{
	tracks_trackinfo *dt;
	datatrack_info *info;
	char description[256];
	
	info=(datatrack_info*)malloc(sizeof(datatrack_info));
	strcpy((char*)&info->device,device);
	info->filedes=-1;
	info->tracksize=cdromlow_datatracksize(device);

	strcpy((char*)&description,"Datatrack of CD ");
	sprintf((char*)&description[strlen((char*)&description)],
		"%#x",cdromlow_cddbnumber(device));
	dt=tracks_create((char*)&description,
			 data,none,
			 datatrack_openpipe,
			 datatrack_closepipe,
			 datatrack_tracksize,
			 datatrack_dataavail,
			 datatrack_valid,
			 datatrack_destroy,
			 info);
	return dt;
}
;

	
