/* lowlebel directory and filehandling */

#ifndef DIRLOW_H
#define DIRLOW_H

#include <sys/stat.h>
#include <unistd.h>
#include <sys/types.h>

/* this structure can be used to compare wether two filenames map to the
 * same inode */

typedef struct 
{
	dev_t st_dev;
	ino_t st_ino;
} dirlow_uniqueinodeid;

int dirlow_isdir(char *d);
int dirlow_islink(char *d);
int dirlow_subdirentries(char *d);
unsigned int dirlow_timestamp(char *);
unsigned int dirlow_filesize(char *);
/* if contentonly is TRUE,only files and subdirectories in d are deleted,
 * not d itself */
int dirlow_removedir(char *d,int contentonly);
int dirlow_mkdirin(char *p,char *d);
/* functions to identify a file by its inode */
dirlow_uniqueinodeid *dirlow_uniqueinodeid_get(char *name);
int dirlow_uniqueinodeid_same(dirlow_uniqueinodeid *first,
			      dirlow_uniqueinodeid *second);

#endif // DIRLOW_H
