/* some Drag and Drop support functions */

#include <gtk/gtk.h>

#include "main.h"
#include "dndsetup.h"

enum 
{
	TARGET_STRING,TARGET_URI_LIST
};

static GtkTargetEntry target_table[] = 
{
	  { "STRING"    , 0, TARGET_STRING },
	  { "text/plain", 0, TARGET_STRING },
	  { "text/uri-list",0,TARGET_URI_LIST }
};

static guint n_targets = sizeof(target_table) / sizeof(target_table[0]);

void dndsetup_drag(GtkWidget *w,
		   GtkSignalFunc dragged,
		   GtkSignalFunc done,
		   void *data)
{
	gtk_drag_source_set (w,
			     GDK_BUTTON1_MASK | GDK_BUTTON3_MASK,
			     target_table, n_targets,
			     GDK_ACTION_COPY | GDK_ACTION_MOVE );
	if (dragged!=NULL)
	    gtk_signal_connect (GTK_OBJECT(w), "drag_data_get",
				dragged,data);
	if (done!=NULL)
	    gtk_signal_connect (GTK_OBJECT(w), "drag_end",
				done,data);
}
;
	
void dndsetup_drop(GtkWidget *w,GtkSignalFunc dropped,void *data)
{
	gtk_drag_dest_set (w,
			   GTK_DEST_DEFAULT_ALL,
			   target_table,n_targets,
			   GDK_ACTION_COPY | GDK_ACTION_MOVE);	
	gtk_signal_connect ( GTK_OBJECT(w), "drag_data_received",
			     dropped,data);
}
;
	
