
#include <gtk/gtk.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>

#include "main.h"
#include "dndsetup.h"
#include "selectlist.h"
#include "filelist.h"
#include "dircache.h"
#include "helpings.h"
#include "menusys.h"
#include "virtualdir.h"
#include "colors.h"
  
char *filelist_headings[]={
   N_("Filename"),
   "",
   N_("Filesize"),
   NULL
};
   
/* vdirroot is a pointer to a virtual directory structure or NULL
 * if present,the vdir struct will be mixed with the actual directory
 * entries,thus enabling not really existent file entries to be displayed */
filelist_info *filelist_create(char *path,
			       virtualdir_dir *vdirroot,
			       selectlist_dropcallback drophandler,
			       int send,
			       menusys_menu *popup,
			       GtkTreeItem *treeentry,
			       GtkSignalFunc doubleclick
			       )
{
   filelist_info *fi;
   GtkWidget *column;
   char header[1024];
   
   int filecount=0;
   
   DIR *dir;
   struct dirent *entry;
   
   /* needed for vdir handling. meaning analogue to 
    * DIR and struct dirent above */
   virtualdir_VDIR *vdir;
   virtualdir_dir  *vdir_entry;
   
   char *file[3];
   char fsbuf[25];
   
   fi=(filelist_info*)malloc(sizeof(filelist_info));
   strcpy((char*)&fi->path,path);
   fi->treeentry=treeentry;
   	
   fi->widget=gtk_scrolled_window_new(NULL,NULL);
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(fi->widget),
				  GTK_POLICY_AUTOMATIC,
				  GTK_POLICY_AUTOMATIC);
   strcpy((char*)&header,"file:");
   strcat((char*)&header,path);
   if (header[strlen((char*)&header)-1]!="/"[0]) 
     strcat((char*)&header,"/");
   fi->selectlistinfo=selectlist_info_create((char*)&header,
					     0,
					     drophandler,
					     send,
					     popup,
					     doubleclick,
					     filelist_headings);
   column=selectlist_create(fi->selectlistinfo,
			    3);       /* create 3 columns*/
				
	gtk_clist_set_selection_mode(GTK_CLIST(column),GTK_SELECTION_EXTENDED);
	gtk_clist_set_column_justification(GTK_CLIST(column),
					   0,
					   GTK_JUSTIFY_LEFT);
	gtk_clist_set_column_width(GTK_CLIST(column),0,200);
	gtk_clist_set_column_justification(GTK_CLIST(column),
					   1,
					   GTK_JUSTIFY_CENTER);
	gtk_clist_set_column_width(GTK_CLIST(column),1,40);
	gtk_clist_set_column_justification(GTK_CLIST(column),
					   2,
					   GTK_JUSTIFY_RIGHT);
	gtk_clist_set_column_width(GTK_CLIST(column),2,96);
	
	file[2]=(char*)&fsbuf;
	
	dir=opendir(path);
	if (dir!=NULL)
	  {		  
		  while ((entry=readdir(dir))!=NULL)
		    {
			    file[0]=(char*)&entry->d_name;
			    if (strcmp(file[0],"..")&&strcmp(file[0],"."))
			      {
				      file[1]=(dircache_isdirin(path,file[0])?"<DIR>":"");
				      helpings_formatnumber(file[2],sizeof(fsbuf),
							    dircache_filesizein(path,file[0]));
				      gtk_clist_append(GTK_CLIST(column),file);
				      filecount++;
			      }
			    ;
		    }
		  ;
		  closedir(dir);
	  }
	;
   
        /* read virtual directory */
        if (vdirroot!=NULL){
	   /* open root directory of vdirroot */
	   vdir=virtualdir_open(vdirroot,"");
	   if (vdir!=NULL)
	     {		
		while((vdir_entry=virtualdir_read(vdir))!=NULL)
		  {
		     /* add non-directories only */
		     if (!S_ISDIR(vdir_entry->mode))
			 {
			    file[0]=(char*)&vdir_entry->name;
			    file[1]="";
			    helpings_formatnumber(file[2],sizeof(fsbuf),
						  vdir_entry->filesize);
			    gtk_clist_append(GTK_CLIST(column),file);
			    gtk_clist_set_foreground(GTK_CLIST(column),
						     filecount,
						     &Blue);
			    filecount++;
			 }
			 ;
		  };
		virtualdir_close(vdir);
	     };
	};
	
	/* Sort the list. First by name, then by <DIR>/!<DIR> */
	gtk_clist_set_sort_column (GTK_CLIST(column),0);	
	gtk_clist_sort (GTK_CLIST(column));	
	gtk_clist_set_sort_column (GTK_CLIST(column),1);
	gtk_clist_set_sort_type (GTK_CLIST(column), 1);	
	gtk_clist_sort (GTK_CLIST(column));	

	gtk_widget_show(column);
	gtk_container_add(GTK_CONTAINER(fi->widget),column); /* Damn the Documentation.
							      * Quite difficult - Documentation is nonexistant */

	return fi;
}
;
		  

void filelist_destroy(filelist_info *fi)
{
	gtk_widget_destroy(fi->widget);
	free(fi->selectlistinfo);
	free(fi);
}
;
