/* Some functions to handle lists of files as given back on drag and drop
 * events or popup events (delete,rename,etc) */

#include "int.h"

#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <stdio.h>
#include <dirent.h>
#include <stdlib.h>

#include <gtk/gtk.h>

#include "preferences.h"
#include "dircache.h"
#include "fileman.h"
#include "linkcount.h"

/* uncomment for debugging */
/* #define DEBUG */

/* the following function can be used to parse a selection as given back
 * by drag and drop and call filehandle(char*) for each separate file */
int fileman_selectionhandler(char *sorig,char *p,int (*filehandle)(char *s,char *p))
{	
	char *item,*newitem,*chr10,*chr13;
	char filename[MAXPATHLENGTH];
	int  success;      // does the file system need reloading ??
   	char *s;

   	/* make a local copy of the selectionstring */
   	s=(char*)malloc(strlen(sorig)+1);
   	strcpy(s,sorig);
   
	success=0;
	item=s;
	do
	  {
		  chr13=strchr(item,13);
		  chr10=strchr(item,10);
		  newitem=chr13;
		  if (((chr10!=NULL) && (chr10<chr13)) || (chr13==NULL))
		      newitem=chr10;
		  if (newitem==NULL) 
		      newitem=item+strlen(item);
		  else
		    {			    
			    *newitem=0;
			    do 
			      {
				      newitem++;
			      }
			    while ((*newitem==10)||(*newitem==13));
		    }
		  ;
		  strcpy((char*)&filename,item);
		  if (strlen((char*)&filename)!=0)
		      success|=filehandle((char*)&filename,p);
		  item=newitem;
	  }
	while (strlen((char*)&filename)>0);
        free(s);
	return success;
}
;

/* get filename without path. if resulting filename is "" as it might happen
 * when the root dir gets added to a cd,it is instead called "root"
 * char *d is expected to be a pointer to an already allocated memory region */
void fileman_strippath(char *filename,char *stripped)
{
	char *d,*dirname;
	
	d=(char*)malloc(MAXPATHLENGTH);
	strcpy(d,filename);
	if (d[strlen(d)-1]=="/"[0]) /* do not allow slash at the end */
	    d[strlen(d)-1]=0;       /* this could otherwise mess up the function */
	
	dirname=d;
	while (strchr(dirname,"/"[0])!=NULL)
	    dirname=strchr(dirname,"/"[0])+1;
		
	strcpy(stripped,dirname);
	if (strlen(stripped)==0) 
	    strcpy(stripped,"root");
	free(d);
}
;	

/* remove the specified single file item. If this is a directory,it will
 * be removed recursively. Parameter char *p is unused and set to NULL */
int fileman_remove_item(char *s,char *p)
{
	char *file;
	int  success;
	
	file=strchr(s,":"[0])+1;
#ifdef DEBUG
	printf ("fileman_remove_item: removing %s\n",file);
#endif
	success=0;
	if (dircache_isdir(file))
	  {
		  success=dirlow_removedir(file,0);
		  if (!success) perror("couldnt remove directory");
	  }	
	else
	  {		  
		  success=(remove(file)==0);
		  if (!success) perror("Couldnt remove file");
	  }
	;
	return success;
}
;	

/* remove a whole batch of files using the function above */
int fileman_remove_items(char *s)
{
	return fileman_selectionhandler(s,NULL,fileman_remove_item);
}
;

/* add a single normal file to the path specified by char *p.
 * this is done by creating a symbolic link to the source file in
 * the destination directory 
 * this is the default addfile handler */
int fileman_defaultaddfile(char *f,char *p,gpointer data)
{
   char *filename;
   char *destination;
   int success;
   
   success=1;
   filename=(char*)malloc(MAXPATHLENGTH);
   fileman_strippath(f,filename);
   destination=(char*)malloc(MAXPATHLENGTH);
   strcpy(destination,p);
   if (destination[strlen(destination)-1]!="/"[0])
     strcat (destination,"/");
   strcat(destination,filename);
   if (symlink(f,destination)==-1)
     {		  
	success=0;
	perror("Couldnt create Symlink");
     }
   ;
   free(filename);
   return success;
}
;

int fileman_defaultmkdir(char *dirname,char *path,gpointer data)
{
   char *destdir;
   int result;
   
   destdir=(char*)malloc(MAXPATHLENGTH);
   strcpy(destdir,path);
   if (destdir[strlen(destdir)-1]!="/"[0])
     strcat (destdir,"/");
   strcat(destdir,dirname);   
   
   result=(mkdir(destdir,0777)!=-1);
   
   free(destdir);
   return result;
};

int fileman_addnormalfile_generic(char *f,char *p,
				  fileman_mkdircall mkdir,
				  fileman_addfilecall addfile,
				  gpointer data)
{
   /* FIXME: print some nice message box here ;-) */
   return addfile(f,p,data);
};


/* add a single directory to the path specified by char *p
 * all the items of this directory will be added depending on wether theyre
 * directories themselves,in which case adddirectory will simply be called
 * recursively,or wether theyre just normal files,which will then be added
 * using addnormalfile() */
int fileman_adddirectory_generic(char *sd,char *p,GList **linkcount,
				 int contentof,
				 fileman_mkdircall mkdircall,
				 fileman_addfilecall addfilecall,
				 gpointer data)
{
   char *dirname;
   char *destdir;
	
   char *sourcefile;
   DIR  *dir;
   struct dirent *entry;
   int success;
   
   success=0;
   dirname=(char*)malloc(MAXPATHLENGTH);
   fileman_strippath(sd,dirname);

   destdir=(char*)malloc(MAXPATHLENGTH);
   strcpy(destdir,p);
   
   /* if the directory itself should be added */
   if (!contentof)
     {
	/* create it */
	if (mkdircall(dirname,p,data)==0)
	  perror("Couldn't create directory");
	
	/* write into it */
	if (destdir[strlen(destdir)-1]!="/"[0])
	  strcat (destdir,"/");
	strcat(destdir,dirname);
     };
	
   sourcefile=(char*)malloc(MAXPATHLENGTH);	
   dir=opendir(sd);
   if (dir!=NULL)
     {		  	
	while ((entry=readdir(dir))!=NULL)
	  {
	     if ( strcmp((char*)&entry->d_name,"..") &&
		 strcmp((char*)&entry->d_name,"."))
	       {				      
		  strcpy(sourcefile,sd);
		  if (sd[strlen(sd)-1]!="/"[0])
					  strcat(sourcefile,"/");
		  strcat(sourcefile,(char*)&entry->d_name);
				      if (dircache_isdir(sourcefile))
		    {						
		       /* check wether filename is
			* a symbolic link and 
			* has been added before
			* to avoid recursive loops */
		       if (linkcount_use(linkcount,sourcefile)<1)
			 fileman_adddirectory_generic(sourcefile,destdir,linkcount,0,
						      mkdircall,
						      addfilecall,
						      data
						      );
		    }
		  else
		    fileman_addnormalfile_generic(sourcefile,destdir,
						  mkdircall,
						  addfilecall,
						  data);
	       }
	     ;
	  }
	     ;
	closedir (dir);
	success=1;
     }
   else
     printf ("fileman_adddirectory: couldnt read directory %s\n",
	     dirname);
   
   free(dirname);
   return success;
}
;

/* add a single generic file item to the patch specified by char *p 
 * this can be either a normal file or a directory */
int fileman_addfile_generic(char*f,char*p,
			    fileman_mkdircall mkdircall,
			    fileman_addfilecall addfilecall,
			    gpointer data
			    )
{
   int changed;
   GList *linkcount=NULL;
   
   changed=0;
   if (dircache_isdir(f))
     {
	changed=fileman_adddirectory_generic(f,p,&linkcount,0,
					     mkdircall,
					     addfilecall,
					     data);
     }
	else
     {
	changed=fileman_addnormalfile_generic(f,p,
					      mkdircall,
					      addfilecall,
					      data);
     }
   ;
   if (linkcount!=NULL)
     linkcount_free(&linkcount);
   return changed;
}
;

/* will be used to copy the contents of a trackstream into a file
 * within the specified path with the name of the stream as filename
 * This function is currently not implemented and will generate a 
 * dummy message only describing the stream it has been called with */
int fileman_addstream(char*s,char *p)
{
	printf ("copy stream-content of %s to %s\n",s,p);
	return 0;
};


/* add an item to the specified path. item can be one of stream,directory,
 * normal file */
int fileman_add_item(char *s,char *p)
{
	int success;
	success=0;
	if (!strncmp("file:",
		     s,
		     5))
	    success|=fileman_addfile(strchr(s,":"[0])+1,p);
	if (!strncmp("stream:",
		     s,
		     7))
	    success|=fileman_addstream(strchr(s,":"[0])+1,p);
	return success;
}
;


int fileman_add_items(char *s,char *p)
{	
	return fileman_selectionhandler(s,p,fileman_add_item);
}
;

typedef struct 
{
	GtkWidget *dlwin;
	GtkWidget *dirname;
	void(*finished)(gpointer);
	gpointer data;
	char path[MAXPATHLENGTH];
} fileman_mkdir_info;

void fileman_mkdir_gotname(GtkWidget *w,gpointer data)
{
	fileman_mkdir_info *info;
	char *name;
	
	info=(fileman_mkdir_info*)data;
	name=gtk_entry_get_text(GTK_ENTRY(info->dirname));
	if (strlen(name)>0)
	  {		  
		  dirlow_mkdirin((char*)&info->path,name);
		  info->finished(info->data);
	  }
	;
	gtk_grab_remove(info->dlwin);
	gtk_widget_destroy(info->dlwin);
	/* free the mkdir_info structure */
	free(data);
}
;

void fileman_mkdir_cancel(GtkWidget *w,gpointer data)
{
	fileman_mkdir_info *info;
	
	info=(fileman_mkdir_info*)data;	
	gtk_grab_remove(info->dlwin);
	gtk_widget_destroy(info->dlwin);
	/* free the mkdir_info structure */
	free(data);
}
;
	

/* display a dialog asking for a directory name,create requested directory
 * then */
void fileman_mkdir_dialog(char *path,
			  void(*finished)(gpointer),
			  gpointer data)
{
	fileman_mkdir_info *info;
	GtkWidget *ok;
	GtkWidget *cancel; /* clicking cancel will not call "finished" */
	
	info=(fileman_mkdir_info*)malloc(sizeof(fileman_mkdir_info));
	strcpy((char*)&info->path,path);
	info->finished=finished;
	info->data=data;

	info->dlwin=gtk_dialog_new();
	gtk_grab_add(info->dlwin);
	
	info->dirname=gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(info->dlwin)->vbox),
			   info->dirname,TRUE,TRUE,5);
	gtk_widget_show(info->dirname);
	
	ok=gtk_button_new_with_label(_("OK"));
	gtk_signal_connect(GTK_OBJECT(ok),"clicked",
			   fileman_mkdir_gotname,info);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(info->dlwin)->action_area),
			   ok,FALSE,FALSE,0);
	gtk_widget_show(ok);
	
	cancel=gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect(GTK_OBJECT(cancel),"clicked",
			   fileman_mkdir_cancel,info);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(info->dlwin)->action_area),
			   cancel,FALSE,FALSE,0);
	gtk_widget_show(cancel);
	
	gtk_window_set_title(GTK_WINDOW(info->dlwin),_("Create Directory"));
	gtk_window_set_position(GTK_WINDOW(info->dlwin),GTK_WIN_POS_CENTER);
	gtk_widget_set_usize(info->dlwin,200,80);
	gtk_widget_show(info->dlwin);
}
;
	
int fileman_file_exist(char *filename)
{
   int f;
   int result=0;
   
   f=open(filename,O_RDONLY);
   if (f!=-1)
     {
	close(f);
	result=1;
#ifdef DEBUG
	printf ("fileman_file_exist: %s exists.\n",filename);
#endif
     }
   else
     {
#ifdef DEBUG
	printf ("fileman_file_exist: %s does not exist (",filename);
	perror ("");
	printf (").\n");
#endif
     };
   return result;
};


     
   
	
				   
	
	
