/* functions responding to the several menu functions */

#include "config.h"
#ifdef HAVE_GNOME
#include <gnome.h>
#else
#include <gtk/gtk.h>
#endif /*HAVE_GNOME*/

#include "main.h"
#include "preferences.h"
#include "helpings.h"
#include "layoutconfig.h"
#include "multisession.h"
#include "fsedit.h"
#include "int.h"

#include "toaster-about.xpm"

void menufunc_quit(gpointer data)
{
	main_quit();
}
;

void menufunc_preferences(gpointer data)
{	
   layoutconfig_widget_show(preferences_editmain,"preferences");
   /* bring the preferences window to the top if it is already shown */
   gdk_window_raise(GTK_WIDGET(preferences_editmain)->window);
}
;

void menufunc_importsession(gpointer data)
{
   multisession_import();
};

void menufunc_deletefsedit(gpointer data)
{
   fsedit_remove_all();
};

GtkWidget *aboutdlg;

void menufunc_about_ok(GtkWidget *w,gpointer data)
{
   gtk_widget_destroy(aboutdlg);
   aboutdlg=NULL;
};

void menufunc_about(gpointer data)
{
   GtkWidget *aboutlogo;
   GtkWidget *aboutok;   
   
   GdkPixmap *logoxpm;
   GdkBitmap *logomask;
   GtkStyle  *style;

   if (aboutdlg==NULL)
     {	
	aboutdlg=gtk_dialog_new();
	gtk_widget_set_usize(aboutdlg,440,150);
	gtk_window_set_title(GTK_WINDOW(aboutdlg),
			     _("About Gnometoaster"));
	gtk_widget_show(aboutdlg);   

	style=gtk_widget_get_style(window);
	logoxpm=gdk_pixmap_create_from_xpm_d(window->window,&logomask,
					     &style->bg[GTK_STATE_NORMAL],
					     toaster_about_xpm
					     );
	aboutlogo=gtk_pixmap_new(logoxpm,logomask);
	gtk_widget_show(aboutlogo);   
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(aboutdlg)->vbox),aboutlogo,1,1,1);

	#ifdef HAVE_GNOME
	  aboutok=gnome_stock_button(GNOME_STOCK_BUTTON_OK);
	#else	  
	  aboutok=gtk_button_new_with_label("OK");
	#endif
	gtk_signal_connect(GTK_OBJECT(aboutok),"clicked",
			   menufunc_about_ok,NULL);
	gtk_widget_show(aboutok);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(aboutdlg)->action_area),aboutok,1,0,0);
     };
};
