/* some helper functions for selection lists,
 * (used e.g. by filelist.c) */

#include "int.h"

#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>

#include "main.h"
#include "dndsetup.h"
#include "selectlist.h"
#include "doubleclick.h"
#include "menusys.h"
#include "helpings.h"

/* uncomment for debugging */
/* #define DEBUG */

/* non-public callback functions */

void selectlist_drag(GtkWidget *w,
		     GdkDragContext *ct,
		     GtkSelectionData *data,
		     guint inf,
		     guint time,
		     selectlist_info *info)
{

   gtk_selection_data_set (data,
			   data->target,
			   8,
			   selectlist_getselection(info),
			   strlen(selectlist_getselection(info)));
   info->is_drag_source=1;
}
;

void selectlist_dragdone(GtkWidget *w,
			 GdkDragContext *c,
			 selectlist_info *info)
{
	gtk_clist_unselect_all(GTK_CLIST(w));
	info->is_drag_source=0;
}
;
	

void selectlist_drop(GtkWidget *w,
	      GdkDragContext *c,
	      gint x,
	      gint y,
	      GtkSelectionData *data,
	      guint inf,
	      guint time,
	      selectlist_info *info)
{
	if ((data->length>=0) && (data->format == 8) 
	    && (info->receiver!=NULL))
	  {
		  info->receiver((gchar*)data->data,x,y);
		  gtk_drag_finish (c,TRUE,FALSE,time);
		  return;
	  }
	;
	gtk_drag_finish (c,FALSE,FALSE,time);
}
;

void selectlist_appendselection(char *s,char *h,char *f) // selectionlist,header,file
{
	char *entry;
	char *cmpcopy;

/* #ifdef DEBUG
	printf ("adding selection \"%s%s\"\n to \"%s\"\n",h,f,s);
#endif 
 */
	cmpcopy=(char*)malloc(SELECTLIST_MAXSELSIZE);
	strcpy(cmpcopy,CRLF);
	strcat(cmpcopy,s);
	
	entry=(char*)malloc(1024);
	strcpy(entry,CRLF);
	strcat(entry,h);
	strcat(entry,f);       
	strcat(entry,CRLF); // entry=CRLF+header+file+CRLF
	
	if ((strstr(cmpcopy,entry)==NULL)&&
	    (strlen(h)+strlen(f)+strlen(CRLF)+strlen(s)<SELECTLIST_MAXSELSIZE))
	  {
		  strcat(s,h);
		  strcat(s,f);
		  strcat(s,CRLF);
	  }
	;
	free(entry);free(cmpcopy);
}
;

/* this function is currently unused - but it is a nice piece of code
 * which we may need again later,so let's just keep it for a while */
void selectlist_removeselection(char *s,char *h,char *f)  // see above
{
	char *entry;
	char *cmpcopy;
	char *foundpos;

   
/*#ifdef DEBUG
	printf ("removing selection %s%s\n",h,f);
#endif
*/	
	cmpcopy=(char*)malloc(SELECTLIST_MAXSELSIZE);
	strcpy(cmpcopy,CRLF);
	strcat(cmpcopy,s);
	
	entry=(char*)malloc(1024);
	strcpy(entry,CRLF);
	strcat(entry,h);
	strcat(entry,f);       
	strcat(entry,CRLF); // entry=CRLF+header+file+CRLF
		
	foundpos=strstr(cmpcopy,entry);
	while (foundpos!=NULL)
	  {
		  strcpy(foundpos,(char*)((int)foundpos+strlen(entry)-2));
		  foundpos=strstr(cmpcopy,entry);
	  }
	;
	strcpy(s,&cmpcopy[2]);        // cut leading cr+lf
	free(entry);free(cmpcopy);
}
;
	

void selectlist_select(GtkCList *clist,gint row,gint column,
		       GdkEventButton *event, selectlist_info *info)
{
   /* only mark row as selected if this has not already happened */
   if (g_list_find(info->selected_lines,(gpointer)row)==NULL)        
     info->selected_lines=g_list_append(info->selected_lines,(gpointer)row);
#ifdef DEBUG
   printf ("selectlist_select: selected row %i\n",row);
   printf ("selectlist.c: selectlist_select current selection:\n\"%s\"\n",
	   selectlist_getselection(info));
#endif
}
;

void selectlist_unselect(GtkCList *clist,gint row,gint column,
		       GdkEventButton *event, selectlist_info *info)
{
#ifdef DEBUG
   	printf ("selectlist_unselect: removing row %i\n",
		row);
#endif
	info->selected_lines=g_list_remove(info->selected_lines,
					   (gpointer)row);
#ifdef DEBUG
	printf ("selectlist.c: selectlist_unselect current selection:\n\"%s\"\n",
		selectlist_getselection(info));
#endif
}
;

/* FIXME: implement selectlist_info_destroy,
 * freeing the selected_lines G_List and our local headings copy */
selectlist_info *selectlist_info_create(char *header,int significant_column,
					selectlist_dropcallback receiver,
					int send,menusys_menu *popup,
					GtkSignalFunc doubleclick,
					char *headings[]
					)
{
   selectlist_info *sel;
	
   sel=(selectlist_info*)malloc(sizeof(selectlist_info));
   sel->selection[0]=0;
   sel->selected_lines=NULL; /* currently,no lines are selected */
   strcpy((char*)&sel->header,header);
   sel->significant_column=significant_column;
   sel->receiver=receiver;
   sel->send=send;
   sel->popup=popup;
   
   sel->doubleclick=doubleclick;
   sel->headings=helpings_translatestringlist(headings);
   
   return sel;
}
;

void selectlist_doubleclick(GtkWidget *w,GdkEventButton *event,
			   selectlist_info *info)
{
   /* react to first mouse button only */
	if ((info->doubleclick!=NULL)&&(event->button==1))
	  {
#ifdef DEBUG
		  printf ("selectlist_doubleclick: callback() with selection \"%s\"\n",
			  selectlist_getselection(info));
#endif		  
	    info->doubleclick(info);
	  }
	;
}
;

GtkWidget *selectlist_create(selectlist_info *sel,int columns)
{
	GtkWidget *selectlist;
	
	if (sel->headings) /* headings available? */
	  { 
	    selectlist=gtk_clist_new_with_titles(columns,
						 sel->headings);
	  }
	else
	    selectlist=gtk_clist_new(columns);

	sel->self=GTK_CLIST(selectlist);
	
	if (sel->send)           /* let the user specify if the current window should be sourced */
	    dndsetup_drag(selectlist,
			  GTK_SIGNAL_FUNC(selectlist_drag),
			  GTK_SIGNAL_FUNC(selectlist_dragdone),
			  sel);
	if (sel->receiver!=NULL) /* do not install drop handler if no handler is specified*/
	    dndsetup_drop(selectlist,GTK_SIGNAL_FUNC(selectlist_drop),sel);
	if (sel->popup!=NULL)
	    menusys_attachpopupmenu(selectlist,
				    sel->popup,
				    (gpointer)sel);
	
	gtk_signal_connect(GTK_OBJECT(selectlist),"select_row",
			   GTK_SIGNAL_FUNC(selectlist_select),sel);
	gtk_signal_connect(GTK_OBJECT(selectlist),"unselect_row",
			   GTK_SIGNAL_FUNC(selectlist_unselect),sel);
	doubleclick_connect(GTK_WIDGET(selectlist),
			    GTK_SIGNAL_FUNC(selectlist_doubleclick),
			    sel);
		
	

	return selectlist;
}
;
		  
char *selectlist_getselection(selectlist_info *info)
{
   GList *i;
   int row;
   char *filename;
   
   info->selection[0]=0; /* clear the selection string */
   /* create the selection string of all rows marked as selected */
   for (i=info->selected_lines;i!=NULL;i=i->next)
     {
	row=(int)i->data; /* get row */
   	/* if significant_column is set to -1,a string addressed by the
	 * hidden gpointer data field of the clist is taken as selection
	 * information */
	if (info->significant_column!=-1)
	  {
		  gtk_clist_get_text(info->self,
				     row,
				     info->significant_column,
				     &filename); 
	  }
	else
	    filename=(char*)gtk_clist_get_row_data(info->self,row);
	/* and finally append new selection entry */
	selectlist_appendselection((char*)&info->selection,
			           (char*)&info->header,filename);
     };
   /* return pointer to selection */
   return ((char*)&info->selection);
};

void selectlist_insert(selectlist_info *info,gint row,gchar *text[])
{
   GList *current;
   /* insert the new item */
   gtk_clist_insert(info->self,row,text);
   /* step through the list of selections */
   for (current=info->selected_lines;
	current!=NULL;
	current=current->next)
     {
	if ((int)current->data>=row)
	  current->data++;
     };
};

void selectlist_remove(selectlist_info *info,gint row)
{
   GList *current;
   /* remove an item */
   gtk_clist_remove(info->self,row);
   /* remove item from selection list */
   info->selected_lines=g_list_remove(info->selected_lines,(gpointer)row);
   /* step through the list of selections */
   for (current=info->selected_lines;
	current!=NULL;
	current=current->next)
     {
	if ((int)current->data>row)
	  current->data--;
     };
};


	
   
