/* Virtualdir is a collection of routines managing virtual directory entries.
 * It is used to display the contents of the last session in gnometoaster. */

#ifndef VIRTUALDIR_H
#define VIRTUALDIR_H

#include <gtk/gtk.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

/* type returned by virtualdir_open() */
#define virtualdir_VDIR GList*

/* this is a compound directory/direntry structure */
typedef struct
{   
   char name[255];              /* name of the directory */
   unsigned long int filesize;  /* file size,if ordinary file */
   unsigned int mode;           /* mode,includes IS_DIR flag */
   GList *entries;              /* a GList of virtualdir_dir,
				 * the entries of our directory.
				 * NULL if ordinary file */
} virtualdir_dir;

   
/* create a new dir */
virtualdir_dir *virtualdir_create(/* informations about the file/directory
				   * to be created */
				  char *name,
				  unsigned int mode,
				  unsigned long int filesize);
/* find entry with name in directory dir */
virtualdir_dir *virtualdir_findentry(virtualdir_dir *dir,
				     gchar *name);
/* find a subdirectory of dir root */
virtualdir_dir *virtualdir_finddir(virtualdir_dir *root,
				   gchar *path);



/* open a subdirectory of dir root for reading */
virtualdir_VDIR *virtualdir_open(virtualdir_dir *root,
				 gchar *path);
/* read a directory entry. this call's structur is similar to
 * the readdir() libc function.  it will return 
 * a pointer to the direntry struct or NULL if the end of the directory
 * has been reached */
virtualdir_dir *virtualdir_read(virtualdir_VDIR *vdir);
/* close a VDIR opened by virtualdir_open */
void virtualdir_close(virtualdir_VDIR *vdir);


/* add a direntry structure to the virtual directory
 * structure specified by root in subdir path,
 * client should be created with virtualdir_create() */
void virtualdir_addentry(virtualdir_dir *root,
			 virtualdir_dir *client,
			 char *path);
/* delete the entire virtual directory structure */
void virtualdir_deletestructure(virtualdir_dir *root);
  
#endif // VIRTUALDIR_H
