/***********************************************************************
 *
 *	Copyright (c) Palm Computing 1995 -- All Rights Reserved
 *
 * PROJECT:  Pilot
 * FILE:     Category.h
 * AUTHOR:	 Art Lamb: March 7, 1995
 *
 * DECLARER: UI
 *
 * DESCRIPTION:
 *	  This file defines category structures and routines.
 *
 ***********************************************************************/
#ifndef __CATEGORY_H__
#define __CATEGORY_H__


typedef struct {
   Word	renamedCategories;
	Char	categoryLabels [dmRecNumCategories] [dmCategoryLength];
	Byte	categoryUniqIDs[dmRecNumCategories];
	Byte	lastUniqID;	// Uniq IDs generated by the device are between
							// 0 - 127.  Those from the PC are 128 - 255.
} AppInfoType;



extern void CategoryCreateList (DmOpenRef db, ListPtr lst, 
	Word currentCategory, Boolean showAllCategoryCreateList)
							SYS_TRAP(sysTrapCategoryCreateList);

extern void CategoryFreeList (DmOpenRef db, ListPtr lst)
							SYS_TRAP(sysTrapCategoryFreeList);

extern Word CategoryFind (DmOpenRef db, CharPtr name)
							SYS_TRAP(sysTrapCategoryFind);

extern void CategoryGetName (DmOpenRef db, Word index, CharPtr name)
							SYS_TRAP(sysTrapCategoryGetName);

extern Boolean CategoryEdit (DmOpenRef db, WordPtr category)
							SYS_TRAP(sysTrapCategoryEdit);

extern Boolean CategorySelect (DmOpenRef db, FormPtr frm, Word ctlID, 
	Word lstID,	Boolean title, WordPtr categoryP, CharPtr categoryName)
							SYS_TRAP(sysTrapCategorySelect);

extern Word CategoryGetNext (DmOpenRef db, Word index)
							SYS_TRAP(sysTrapCategoryGetNext);

extern void CategorySetTriggerLabel (ControlPtr ctl, CharPtr name)
							SYS_TRAP(sysTrapCategorySetTriggerLabel);

extern void CategoryTruncateName (CharPtr name, Word maxWidth)
							SYS_TRAP(sysTrapCategoryTruncateName);


#endif // __CATEGORY_H__
