#
#  $Id: TimeSync.py,v 1.12 1999/12/11 12:35:11 rob Exp $
#
#  Copyright 1998-1999 Rob Tillotson <robt@debian.org>
#  All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee or royalty is
#  hereby granted, provided that the above copyright notice appear in
#  all copies and that both the copyright notice and this permission
#  notice appear in supporting documentation or portions thereof,
#  including modifications, that you you make.
#
#  THE AUTHOR ROB TILLOTSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
#  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
#  AND FITNESS.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
#  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
#  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
#  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE!
#
"""Sync the device clock to the desktop.
"""

__version__ = '$Id: TimeSync.py,v 1.12 1999/12/11 12:35:11 rob Exp $'

__copyright__ = 'Copyright 1998-1999 Rob Tillotson <robt@debian.org>'

import Pyrite
import Pyrite.Conduit
from Pyrite import _

import time

class Conduit(Pyrite.Conduit.Conduit):
    name = 'TimeSync'
    version = Pyrite.version
    author = Pyrite.author
    url = ''
    description = _("Synchronizes the clocks on the PalmOS device and desktop.")

    def __init__(self):
	Pyrite.Conduit.Conduit.__init__(self)

    def __call__(self, app):
	self.log(_("Clock on device: %s") % time.ctime(app.remote.get_time()))
	t = int(time.time())
	app.remote.set_time(t)
	self.log(_("Clock set to: %s") % time.ctime(t))
