# Main-module of X-CD-Roast
# 23.1.96 T. Niederreiter

# some handy defines:
set XCDR_VERSION "0.96e"
set VERSION $XCDR_VERSION
set SUB_VERSION ""
set RELEASE_DATE "26 Nov 1998"

# this variable should be set from the configure-script via
# the ET-Wrapper.  
if { [info exists LIBDIRPREFIX] == 0 } {
	# if not set then use the default value
	set LIBDIRPREFIX "/usr/local"
}

set LIBDIR "$LIBDIRPREFIX/lib/xcdroast-$VERSION"
 
# add some important paths to search-path
set env(PATH) "$env(PATH):/sbin:/usr/sbin"

# hide the root-window
wm withdraw .

# save argument-list
set roast_arguments $argv

# scan arguments

# show help
set tmpidx [lsearch $roast_arguments "--help"]
set tmpidx2 [lsearch $roast_arguments "-?"]
if { $tmpidx != -1 || $tmpidx2 != -1 } {
	puts "X-CD-Roast Version $XCDR_VERSION"
	puts "Usage: $argv0 \[Options\]"
	puts "Options:"
	puts "    -scanscsi num  : scan for 0 <= num <= 64 scsi devices (default 16)"
	puts "    -scanide num   : scan for 0 <= ide <= 8 ide devices (default 8)"
	puts "    -configdir dir : directory where to save config-data (default ~/.xcdroast)"
	puts "    -libdir dir    : library-directory (default $LIBDIR)"
	puts "    -display host  : redirect display to host"
	puts "    -usecdparanoia : use cdparanoia to read audio-tracks (BETA-Feature)"
	puts "    -nonroot       : activate nonroot-mode"
	puts "    -debug level   : enable debug-mode (level >=1)"
	puts "" 
	puts "(Options -configdir and -libdir work only for root-user in nonroot-mode)"
	exit
}	

# default scan-range for ide devices
set scanide_number 8 
set tmpidx [lsearch $roast_arguments "-scanide"]
if { $tmpidx != -1 } {

	set scanide_number [lindex $roast_arguments [expr $tmpidx + 1]]

	if { $scanide_number < 0 || $scanide_number > 8 } {
		puts "Error: Argument \"-scanide\" accepts only values 0 - 8"
		exit
	}
}

# default scan-range for scsi devices
set scanscsi_number 16
set tmpidx [lsearch $roast_arguments "-scanscsi"]
if { $tmpidx != -1 } {

	set scanscsi_number [lindex $roast_arguments [expr $tmpidx + 1]]

	if { $scanscsi_number < 0 || $scanscsi_number > 64 } {
		puts "Error: Argument \"-scanscsi\" accepts only values 0 - 64"
		exit
	}
}

# set $HOME/.xcdroast as default configuration-dir
set CONFDIR "[glob ~/]/.xcdroast"

# backup vars to restore later if needed
set CONFDIRORG $CONFDIR
set LIBDIRORG $LIBDIR

# set config-directory
set tmpidx [lsearch $roast_arguments "-configdir"]
if { $tmpidx != -1 } {
	set CONFDIR  [lindex $roast_arguments [expr $tmpidx + 1]]
}	


# set lib-directory
set tmpidx [lsearch $roast_arguments "-libdir"]
if { $tmpidx != -1 } {
	set LIBDIR  [lindex $roast_arguments [expr $tmpidx + 1]]
}	

# set quick-load (dont show logo in main-screen)
set QUICKLOAD 0
set tmpidx [lsearch $roast_arguments "-quickload"]
if { $tmpidx != -1 } {
	set QUICKLOAD 1
}	

# set debug-level
set DEBUG 0
set tmpidx [lsearch $roast_arguments "-debug"]
if { $tmpidx != -1 } {
	set DEBUG [lindex $roast_arguments [expr $tmpidx + 1]] 
}	
if { $DEBUG == "" } { set DEBUG 1 }

# experimental support for cdparanoia (very crude at the moment)
set CDPARANOIA ""
set CDPARAOPTIONS ""
set tmpidx [lsearch $roast_arguments "-usecdparanoia"]
if { $tmpidx != -1 } {
	set CDPARANOIA 1	
}	

# activate nonroot-patch
set NONROOT 0
set tmpidx [lsearch $roast_arguments "-nonroot"]
if { $tmpidx != -1 } {
	set NONROOT 1
}

# set LIBDIR/nonroot.config as default root configuration-dir
# not overridable by command line arguments
set ROOTCONFDIR "$LIBDIR/nonroot.config"

#-----------------------------------------------------

# check here if we have to start in nonroot-mode (by checking if the
# globalconfig-file exists)

if { [file isdirectory $ROOTCONFDIR] == 1 } {
	# found a root-config-dir -> switch to nonroot mode
	set NONROOT 1	
	if { $DEBUG > 0 } {
		puts "Debug: Found $ROOTCONFDIR -> using nonroot-mode"
	} 
}

# are we running as not root?
if { ([getuid] != 0) && ($NONROOT == 1) } {
	# restore original lib and confdir (to ignore all changes from
	# commandline if any)
	set LIBDIR $LIBDIRORG
	set CONFDIR $CONFDIRORG 
}

# Check if LIBDIR is found
if { [file isdirectory $LIBDIR] == 0 } {
	puts "Error: Library-Directory \"$LIBDIR\" not found."
	exit
}

# Check if ROOTCONFDIR is found
if { ([file isdirectory $ROOTCONFDIR] == 0) && ([getuid] == 0) &&($NONROOT == 1) } {
      	# create confdir if it does not exist
      	exec mkdir $ROOTCONFDIR
	if { $DEBUG > 0 } {
		puts "Debug: creating $ROOTCONFDIR for nonroot-mode"
	} 
}


# Check if CONFDIR is found
if { [file isdirectory $CONFDIR] == 0 } {
	# create confdir if it does not exists
	exec mkdir $CONFDIR
	chownfile $CONFDIR
}

# Check if /dev/sr* devices are there
if { [catch { glob "/dev/sr*" }] != 0 } {
	puts "Error: No /dev/sr-Devices found."
	puts "Please create first the devices. Run \"./MAKEDEVICES.sh\""
	puts "in the xcdroast-$VERSION directory."
	exit
}

# Check if /dev/sg* devices are there
set nrsgdev 0
set nrsgdev2 0
catch { set nrsgdev [llength [glob "/dev/sg\[0-9\]"]] }
catch { set nrsgdev2 [llength [glob "/dev/sg1\[0-5\]"]] }
if { [expr $nrsgdev + $nrsgdev2] < 16 } {
	puts "Error: Some or all Generic-SCSI-Devices are missing."
	puts "Please create first the devices. Run \"./MAKEDEVICES.sh\""
	puts "in the xcdroast-$VERSION directory."
	exit
}


# Check if user is root (effective user id - so that suid-bit works)
set userid [geteuid]
if { $userid != "0" } {
        Msg_NoRoot .noroot .
        exit
}

# Prepare some variables

createglobalvars
init_paths

# Determine if program is called by root or another user
if { $NONROOT == 1 } {
	set CALLERID [getuid]
	if { $CALLERID == "0"} {
		set ROOTMODE 1
	} else {
		set ROOTMODE 0
	}

	# Let Program work with the effective user ID of the caller, 
	# let it only work as 'root' if really necessary.
	workascaller
}

# Do access the sg-devices to force the kernel to load the 
# sg-module if available.
if { $scanscsi_number > 0 } {

	# dummy call to load module
	scsiinq -s 1

	# Check if sg-module is loaded
	if { [checksgmodule] != 0 } {
		set stat [Msg_NoSGFound .nosg .]
		if { $stat == 1 } {
			exit
		}
	}
}

# Process Hardware-Detection

workasroot

getscsidevices
getidedevices
getdiskinfo
getcddrives
getpartinfo

workascaller

# Check if cdrecord scsi-kernel-patch is installed (and needed)
if { [checkscsipatch] != 0 } {
	set stat [Msg_NoScsiPatch .nosptch .]
	if { $stat == 1 } {
		exit
	}
}

if { $NONROOT == 0 } {
	# Load configuration-file
	if { [loadcfgfile $CONFDIR/$CFGFILE] != 0 } {
		Msg_ConfFileNotFound .dlg . 
		set forcesetup 1		
	}
} else {
	# Load root's configuration-file
	if { [loadcfgfile $ROOTCONFDIR/$CFGFILE] != 0 } {
		if { $ROOTMODE == 1 } {
			Msg_ConfFileNotFound .dlg . 
			set forcesetup 1
		} else {
			puts "Error: Root has to configure xcdroast before"
			puts "nonroot users can use it!"
			exit
		}
	}

	# Load user's personal configuration ignoring modifications the user is
	# not allowed to
	if { $ROOTMODE == 0 } {
		# save variables which user is not allowed to modify
		set BACK_DEFAULT_PART $XCDR_DEFAULT_PART 
		set BACK_IMAGE_FIXED $XCDR_IMAGE_FIXED
		set BACK_IMAGE_MNTPNT $XCDR_IMAGE_MNTPNT
		set BACK_IMAGE_MNTPNT2 $XCDR_IMAGE_MNTPNT2
		set BACK_IMAGE_PART $XCDR_IMAGE_PART
		set BACK_IMAGE_PART2 $XCDR_IMAGE_PART2
 
		# Load user's configuration-file (ignore errors)
		if { [loadcfgfile $CONFDIR/$CFGFILE] != 0 } {
			;
		}
 
 		# restore variables which user is not allowed to modify
		set XCDR_DEFAULT_PART $BACK_DEFAULT_PART 
		set XCDR_IMAGE_FIXED $BACK_IMAGE_FIXED
		set XCDR_IMAGE_MNTPNT $BACK_IMAGE_MNTPNT
		set XCDR_IMAGE_MNTPNT2 $BACK_IMAGE_MNTPNT2
		set XCDR_IMAGE_PART $BACK_IMAGE_PART
		set XCDR_IMAGE_PART2 $BACK_IMAGE_PART2
	} else {
 		# in root mode set CONFDIR variable to ROOTCONFDIR to store 
		# configuration at the correct place
		set CONFDIR $ROOTCONFDIR
	}
}

if { $NONROOT == 0 } {
	set CDPARACONF "$CONFDIR/cdparanoia.conf"
} else {
	# in nonroot-mode look first in root-conf-dir
	set CDPARACONF "$ROOTCONFDIR/cdparanoia.conf"
}

# check if in cdparanoia-mode is already a config-file
if { $CDPARANOIA == 1 } {

	if { ([file exists $CDPARACONF] == 0) && ($NONROOT == 1) && ($ROOTMODE == 0) } {
		puts "Error: CDParanoia-Mode must be first configured by root"
		exit
	}
	if { [file exists $CDPARACONF] == 0 } {
		# create config-file
		createcdparanoiaconf $CDPARACONF
		Msg_CreatedCDParaConf .dlg . $CDPARACONF
		
		puts "Please edit: $CDPARACONF\n"
		puts "Exiting X-CD-Roast..."
		exit
	}

	# load the config-file (does also syntax checks)
	loadcdparanoiaconf $CDPARACONF 
}

# Check if loaded configuration-file was from a different 
# program-version.
if { $VERSION != $XCDR_VERSION } {
	Msg_ConfFileWrongVersion .dlg . $VERSION $XCDR_VERSION
	set XCDR_VERSION $VERSION
	set XCDR_DISCLAIMERDONTSHOWAGAIN 0
	set forcesetup 1
}

# Check if scsisetup has changed
set scsistatus [checkscsisetup]
if { $forcesetup !=1 && $scsistatus != 0 } {
	Msg_ScsiSetupWarning .dlg . $scsistatus
	set forcesetup 1
}


# Check if the binaries are there
if { [catch { glob $CDRECORD }] != 0 } {
       puts "Error: Installation-Error - Not all binaries found."
       puts "Please install X-CD-Roast correctly."
       exit
}

# output versions
if { $DEBUG > 0 } {
	puts "Debug: Starting X-CD-Roast $VERSION - $SUB_VERSION"
	puts "Debug: Version TCL=$tcl_patchLevel, TK=$tk_patchLevel, Tix=$tix_patchLevel"
	if { $CDPARANOIA == "" } {
		puts "Debug: cdparanoia: no, nonroot: $NONROOT"
	} else {
		puts "Debug: cdparanoia: $CDPARANOIA $CDPARAOPTIONS, nonroot: $NONROOT"
	}
}

MkMainWindow .root

log . "started"

# set endian
setEndianorder


