/*  Note: You are free to use whatever license you want.
    Eventually you will be able to edit it within Glade. */

/*  AlsaPlayer
 *  Copyright (C) <YEAR> <AUTHORS>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "gladesrc.h"

GtkWidget*
get_widget                             (GtkWidget       *widget,
                                        gchar           *widget_name)
{
  GtkWidget *parent, *found_widget;

  for (;;)
    {
      if (GTK_IS_MENU (widget))
        parent = gtk_menu_get_attach_widget (GTK_MENU (widget));
      else
        parent = widget->parent;
      if (parent == NULL)
        break;
      widget = parent;
    }

  found_widget = (GtkWidget*) gtk_object_get_data (GTK_OBJECT (widget),
                                                   widget_name);
  if (!found_widget)
    g_warning ("Widget not found: %s", widget_name);
  return found_widget;
}

/* This is an internally used function to set notebook tab widgets. */
void
set_notebook_tab                       (GtkWidget       *notebook,
                                        gint             page_num,
                                        GtkWidget       *widget)
{
  GtkNotebookPage *page;
  GtkWidget *notebook_page;

  page = (GtkNotebookPage*) g_list_nth (GTK_NOTEBOOK (notebook)->children, page_num)->data;
  notebook_page = page->child;
  gtk_widget_ref (notebook_page);
  gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), page_num);
  gtk_notebook_insert_page (GTK_NOTEBOOK (notebook), notebook_page,
                            widget, page_num);
  gtk_widget_unref (notebook_page);
}

static GList *pixmaps_directories = NULL;

/* Use this function to set the directory containing installed pixmaps. */
void
add_pixmap_directory                   (gchar           *directory)
{
  pixmaps_directories = g_list_prepend (pixmaps_directories, g_strdup (directory));
}

/* This is an internally used function to check if a pixmap file exists. */
#ifndef G_DIR_SEPARATOR_S
#define G_DIR_SEPARATOR_S "/"
#endif
gchar*
check_file_exists                      (gchar           *directory,
                                        gchar           *filename)
{
  gchar *full_filename;
  struct stat s;
  gint status;

  full_filename = (gchar *) g_malloc (strlen (directory) + 1 + strlen (filename) + 1);
  strcpy (full_filename, directory);
  strcat (full_filename, G_DIR_SEPARATOR_S);
  strcat (full_filename, filename);

  status = stat (full_filename, &s);
  if (status == 0 && S_ISREG (s.st_mode))
    return full_filename;
  g_free (full_filename);
  return NULL;
}

/* This is an internally used function to create pixmaps. */
GtkWidget*
create_pixmap                          (GtkWidget       *widget,
                                        gchar           *filename)
{
  gchar *found_filename = NULL;
  GdkColormap *colormap;
  GdkPixmap *gdkpixmap;
  GdkBitmap *mask;
  GtkWidget *pixmap;
  GList *elem;

  /* We first try any pixmaps directories set by the application. */
  elem = pixmaps_directories;
  while (elem)
    {
      found_filename = check_file_exists ((gchar*)elem->data, filename);
      if (found_filename)
        break;
      elem = elem->next;
    }

  /* If we haven't found the pixmap, try the source directory. */
  if (!found_filename)
    {
      found_filename = check_file_exists ("../../gui/pixmaps", filename);
    }

  if (!found_filename)
    {
      g_print ("Couldn't find pixmap file: %s", filename);
      return NULL;
    }

  colormap = gtk_widget_get_colormap (widget);
  gdkpixmap = gdk_pixmap_colormap_create_from_xpm (NULL, colormap, &mask,
                                                   NULL, found_filename);
  g_free (found_filename);
  if (gdkpixmap == NULL)
    return NULL;
  pixmap = gtk_pixmap_new (gdkpixmap, mask);
  gdk_pixmap_unref (gdkpixmap);
  gdk_bitmap_unref (mask);
  return pixmap;
}

GtkWidget*
create_main_window ()
{
  GtkWidget *main_window;
  GtkWidget *main_box;
  GtkWidget *info_box;
  GtkWidget *control_box;
  GtkWidget *vbox25;
  GtkWidget *hbox36;
  GtkWidget *pos_scale;
  GtkWidget *hbox35;
  GtkWidget *button_box;
  GtkWidget *cd_button;
  GtkWidget *stop_button;
  GtkWidget *play_button;
  GtkWidget *prev_button;
  GtkWidget *next_button;
  GtkWidget *playlist_button;
  GtkWidget *vbox26;
  GtkWidget *pitch_box;
  GtkWidget *hbox28;
  GtkWidget *pause_button;
  GtkWidget *reverse_button;
  GtkWidget *forward_button;
  GtkWidget *pitch_scale;
  GtkWidget *hbox37;
  GtkWidget *vol_scale;
  GtkWidget *bal_scale;

  main_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (main_window), "main_window", main_window);
  gtk_widget_set_usize (main_window, 400, 90);
  gtk_container_border_width (GTK_CONTAINER (main_window), 2);
  gtk_window_set_title (GTK_WINDOW (main_window), "AlsaPlayer");

  main_box = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (main_window), "main_box", main_box);
  gtk_widget_show (main_box);
  gtk_container_add (GTK_CONTAINER (main_window), main_box);

  info_box = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (main_window), "info_box", info_box);
  gtk_widget_show (info_box);
  gtk_box_pack_start (GTK_BOX (main_box), info_box, TRUE, TRUE, 0);

  control_box = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (main_window), "control_box", control_box);
  gtk_widget_show (control_box);
  gtk_box_pack_start (GTK_BOX (main_box), control_box, FALSE, TRUE, 0);

  vbox25 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (main_window), "vbox25", vbox25);
  gtk_widget_show (vbox25);
  gtk_box_pack_start (GTK_BOX (control_box), vbox25, TRUE, TRUE, 0);

  hbox36 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (main_window), "hbox36", hbox36);
  gtk_widget_show (hbox36);
  gtk_box_pack_start (GTK_BOX (vbox25), hbox36, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (hbox36), 2);

  pos_scale = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 0, 1, 5, 5)));
  gtk_object_set_data (GTK_OBJECT (main_window), "pos_scale", pos_scale);
  gtk_widget_show (pos_scale);
  gtk_box_pack_start (GTK_BOX (hbox36), pos_scale, TRUE, TRUE, 0);
  gtk_scale_set_draw_value (GTK_SCALE (pos_scale), FALSE);

  hbox35 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (main_window), "hbox35", hbox35);
  gtk_widget_show (hbox35);
  gtk_box_pack_start (GTK_BOX (vbox25), hbox35, TRUE, TRUE, 0);

  button_box = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (main_window), "button_box", button_box);
  gtk_widget_show (button_box);
  gtk_box_pack_start (GTK_BOX (hbox35), button_box, FALSE, TRUE, 0);

  cd_button = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (main_window), "cd_button", cd_button);
  gtk_widget_show (cd_button);
  gtk_box_pack_start (GTK_BOX (button_box), cd_button, FALSE, FALSE, 0);
  gtk_widget_set_usize (cd_button, 30, 28);

  stop_button = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (main_window), "stop_button", stop_button);
  gtk_widget_show (stop_button);
  gtk_box_pack_start (GTK_BOX (button_box), stop_button, FALSE, FALSE, 0);
  gtk_widget_set_usize (stop_button, 30, 28);

  play_button = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (main_window), "play_button", play_button);
  gtk_widget_show (play_button);
  gtk_box_pack_start (GTK_BOX (button_box), play_button, FALSE, FALSE, 0);
  gtk_widget_set_usize (play_button, 30, 28);

  prev_button = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (main_window), "prev_button", prev_button);
  gtk_widget_show (prev_button);
  gtk_box_pack_start (GTK_BOX (button_box), prev_button, FALSE, FALSE, 0);
  gtk_widget_set_usize (prev_button, 30, 28);

  next_button = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (main_window), "next_button", next_button);
  gtk_widget_show (next_button);
  gtk_box_pack_start (GTK_BOX (button_box), next_button, FALSE, FALSE, 0);
  gtk_widget_set_usize (next_button, 30, 28);

  playlist_button = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (main_window), "playlist_button", playlist_button);
  gtk_widget_show (playlist_button);
  gtk_box_pack_start (GTK_BOX (button_box), playlist_button, TRUE, TRUE, 0);
  gtk_widget_set_usize (playlist_button, 30, 28);

  vbox26 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (main_window), "vbox26", vbox26);
  gtk_widget_show (vbox26);
  gtk_box_pack_start (GTK_BOX (hbox35), vbox26, TRUE, TRUE, 0);

  pitch_box = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (main_window), "pitch_box", pitch_box);
  gtk_widget_show (pitch_box);
  gtk_box_pack_start (GTK_BOX (vbox26), pitch_box, TRUE, TRUE, 0);

  hbox28 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (main_window), "hbox28", hbox28);
  gtk_widget_show (hbox28);
  gtk_box_pack_start (GTK_BOX (pitch_box), hbox28, FALSE, TRUE, 0);

  pause_button = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (main_window), "pause_button", pause_button);
  gtk_widget_show (pause_button);
  gtk_box_pack_start (GTK_BOX (hbox28), pause_button, FALSE, TRUE, 0);
  gtk_widget_set_usize (pause_button, 22, 20);

  reverse_button = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (main_window), "reverse_button", reverse_button);
  gtk_widget_show (reverse_button);
  gtk_box_pack_start (GTK_BOX (hbox28), reverse_button, FALSE, TRUE, 0);
  gtk_widget_set_usize (reverse_button, 22, 20);

  forward_button = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (main_window), "forward_button", forward_button);
  gtk_widget_show (forward_button);
  gtk_box_pack_start (GTK_BOX (hbox28), forward_button, FALSE, TRUE, 0);
  gtk_widget_set_usize (forward_button, 22, 20);

  pitch_scale = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (0, -233, 234, 1, 1, 1)));
  gtk_object_set_data (GTK_OBJECT (main_window), "pitch_scale", pitch_scale);
  gtk_widget_show (pitch_scale);
  gtk_box_pack_start (GTK_BOX (pitch_box), pitch_scale, TRUE, TRUE, 0);
  gtk_scale_set_draw_value (GTK_SCALE (pitch_scale), FALSE);

  hbox37 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (main_window), "hbox37", hbox37);
  gtk_widget_show (hbox37);
  gtk_box_pack_start (GTK_BOX (vbox26), hbox37, TRUE, TRUE, 0);

  vol_scale = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (100, 0, 101, 1, 1, 1)));
  gtk_object_set_data (GTK_OBJECT (main_window), "vol_scale", vol_scale);
  gtk_widget_show (vol_scale);
  gtk_box_pack_start (GTK_BOX (hbox37), vol_scale, TRUE, TRUE, 0);
  gtk_scale_set_draw_value (GTK_SCALE (vol_scale), FALSE);

  bal_scale = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (100, 0, 201, 1, 1, 1)));
  gtk_object_set_data (GTK_OBJECT (main_window), "bal_scale", bal_scale);
  gtk_widget_show (bal_scale);
  gtk_box_pack_start (GTK_BOX (hbox37), bal_scale, TRUE, TRUE, 0);
  gtk_scale_set_draw_value (GTK_SCALE (bal_scale), FALSE);

  return main_window;
}

GtkWidget*
create_playlist_window ()
{
  GtkWidget *playlist_window;
  GtkWidget *vbox5;
  GtkWidget *hbox16;
  GtkWidget *scrolledwindow1;
  GtkWidget *viewport1;
  GtkWidget *playlist;
  GtkWidget *label2;
  GtkWidget *label3;
  GtkWidget *vbox6;
  GtkWidget *add_button;
  GtkWidget *load_button;
  GtkWidget *save_button;
  GtkWidget *del_button;
  GtkWidget *clear_button;
  GtkWidget *playlist_status;

  playlist_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (playlist_window), "playlist_window", playlist_window);
  gtk_widget_set_usize (playlist_window, 480, 250);
  gtk_window_set_title (GTK_WINDOW (playlist_window), "Queue");

  vbox5 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (playlist_window), "vbox5", vbox5);
  gtk_widget_show (vbox5);
  gtk_container_add (GTK_CONTAINER (playlist_window), vbox5);

  hbox16 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (playlist_window), "hbox16", hbox16);
  gtk_widget_show (hbox16);
  gtk_box_pack_start (GTK_BOX (vbox5), hbox16, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (hbox16), 8);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (playlist_window), "scrolledwindow1", scrolledwindow1);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (hbox16), scrolledwindow1, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  viewport1 = gtk_viewport_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (playlist_window), "viewport1", viewport1);
  gtk_widget_show (viewport1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), viewport1);
  gtk_viewport_set_shadow_type (GTK_VIEWPORT (viewport1), GTK_SHADOW_NONE);

  playlist = gtk_clist_new (2);
  gtk_object_set_data (GTK_OBJECT (playlist_window), "playlist", playlist);
  gtk_widget_show (playlist);
  gtk_container_add (GTK_CONTAINER (viewport1), playlist);
  gtk_clist_set_column_width (GTK_CLIST (playlist), 0, 80);
  gtk_clist_set_column_width (GTK_CLIST (playlist), 1, 80);
  gtk_clist_column_titles_hide (GTK_CLIST (playlist));

  label2 = gtk_label_new ("label2");
  gtk_object_set_data (GTK_OBJECT (playlist_window), "label2", label2);
  gtk_widget_show (label2);
  gtk_clist_set_column_widget (GTK_CLIST (playlist), 0, label2);

  label3 = gtk_label_new ("label3");
  gtk_object_set_data (GTK_OBJECT (playlist_window), "label3", label3);
  gtk_widget_show (label3);
  gtk_clist_set_column_widget (GTK_CLIST (playlist), 1, label3);

  vbox6 = gtk_vbox_new (FALSE, 6);
  gtk_object_set_data (GTK_OBJECT (playlist_window), "vbox6", vbox6);
  gtk_widget_show (vbox6);
  gtk_box_pack_start (GTK_BOX (hbox16), vbox6, FALSE, TRUE, 6);

  add_button = gtk_button_new_with_label ("Add...");
  gtk_object_set_data (GTK_OBJECT (playlist_window), "add_button", add_button);
  gtk_widget_show (add_button);
  gtk_box_pack_start (GTK_BOX (vbox6), add_button, FALSE, TRUE, 0);
  gtk_widget_set_usize (add_button, 70, 22);

  load_button = gtk_button_new_with_label ("Load...");
  gtk_object_set_data (GTK_OBJECT (playlist_window), "load_button", load_button);
  gtk_widget_show (load_button);
  gtk_box_pack_start (GTK_BOX (vbox6), load_button, FALSE, TRUE, 0);
  gtk_widget_set_usize (load_button, 70, -2);

  save_button = gtk_button_new_with_label ("Save...");
  gtk_object_set_data (GTK_OBJECT (playlist_window), "save_button", save_button);
  gtk_widget_show (save_button);
  gtk_box_pack_start (GTK_BOX (vbox6), save_button, FALSE, TRUE, 0);
  gtk_widget_set_usize (save_button, 70, -2);

  del_button = gtk_button_new_with_label ("remove");
  gtk_object_set_data (GTK_OBJECT (playlist_window), "del_button", del_button);
  gtk_widget_show (del_button);
  gtk_box_pack_start (GTK_BOX (vbox6), del_button, FALSE, TRUE, 0);

  clear_button = gtk_button_new_with_label ("clear");
  gtk_object_set_data (GTK_OBJECT (playlist_window), "clear_button", clear_button);
  gtk_widget_show (clear_button);
  gtk_box_pack_start (GTK_BOX (vbox6), clear_button, FALSE, TRUE, 0);

  playlist_status = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (playlist_window), "playlist_status", playlist_status);
  gtk_widget_show (playlist_status);
  gtk_box_pack_start (GTK_BOX (vbox5), playlist_status, FALSE, TRUE, 4);

  return playlist_window;
}

GtkWidget*
create_playlist_load ()
{
  GtkWidget *playlist_load;
  GtkWidget *ok_button1;
  GtkWidget *cancel_button1;

  playlist_load = gtk_file_selection_new ("Load Playlist");
  gtk_object_set_data (GTK_OBJECT (playlist_load), "playlist_load", playlist_load);
  gtk_container_border_width (GTK_CONTAINER (playlist_load), 10);

  ok_button1 = GTK_FILE_SELECTION (playlist_load)->ok_button;
  gtk_object_set_data (GTK_OBJECT (playlist_load), "ok_button1", ok_button1);
  gtk_widget_show (ok_button1);
  GTK_WIDGET_SET_FLAGS (ok_button1, GTK_CAN_DEFAULT);

  cancel_button1 = GTK_FILE_SELECTION (playlist_load)->cancel_button;
  gtk_object_set_data (GTK_OBJECT (playlist_load), "cancel_button1", cancel_button1);
  gtk_widget_show (cancel_button1);
  GTK_WIDGET_SET_FLAGS (cancel_button1, GTK_CAN_DEFAULT);

  return playlist_load;
}

GtkWidget*
create_playlist_save ()
{
  GtkWidget *playlist_save;
  GtkWidget *ok_button2;
  GtkWidget *cancel_button2;

  playlist_save = gtk_file_selection_new ("Save Playlist");
  gtk_object_set_data (GTK_OBJECT (playlist_save), "playlist_save", playlist_save);
  gtk_container_border_width (GTK_CONTAINER (playlist_save), 10);

  ok_button2 = GTK_FILE_SELECTION (playlist_save)->ok_button;
  gtk_object_set_data (GTK_OBJECT (playlist_save), "ok_button2", ok_button2);
  gtk_widget_show (ok_button2);
  GTK_WIDGET_SET_FLAGS (ok_button2, GTK_CAN_DEFAULT);

  cancel_button2 = GTK_FILE_SELECTION (playlist_save)->cancel_button;
  gtk_object_set_data (GTK_OBJECT (playlist_save), "cancel_button2", cancel_button2);
  gtk_widget_show (cancel_button2);
  GTK_WIDGET_SET_FLAGS (cancel_button2, GTK_CAN_DEFAULT);

  return playlist_save;
}

GtkWidget*
create_effects_window ()
{
  GtkWidget *effects_window;
  GtkWidget *vbox23;
  GtkWidget *hbox31;
  GtkWidget *plugin_list_box;
  GtkWidget *scrolledwindow2;
  GtkWidget *effects_list;
  GtkWidget *label16;
  GtkWidget *label17;
  GtkWidget *parameter_box;
  GtkWidget *button_box;
  GtkWidget *ok_button;

  effects_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (effects_window), "effects_window", effects_window);
  gtk_widget_set_usize (effects_window, 500, 300);
  gtk_window_set_title (GTK_WINDOW (effects_window), "Effects");

  vbox23 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (effects_window), "vbox23", vbox23);
  gtk_widget_show (vbox23);
  gtk_container_add (GTK_CONTAINER (effects_window), vbox23);

  hbox31 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (effects_window), "hbox31", hbox31);
  gtk_widget_show (hbox31);
  gtk_box_pack_start (GTK_BOX (vbox23), hbox31, TRUE, TRUE, 0);

  plugin_list_box = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (effects_window), "plugin_list_box", plugin_list_box);
  gtk_widget_show (plugin_list_box);
  gtk_box_pack_start (GTK_BOX (hbox31), plugin_list_box, FALSE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (plugin_list_box), 8);

  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (effects_window), "scrolledwindow2", scrolledwindow2);
  gtk_widget_show (scrolledwindow2);
  gtk_box_pack_start (GTK_BOX (plugin_list_box), scrolledwindow2, TRUE, TRUE, 0);
  gtk_widget_set_usize (scrolledwindow2, 128, -2);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  effects_list = gtk_ctree_new (2, 0);
  gtk_object_set_data (GTK_OBJECT (effects_window), "effects_list", effects_list);
  gtk_widget_show (effects_list);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), effects_list);
  gtk_clist_set_column_width (GTK_CLIST (effects_list), 0, 80);
  gtk_clist_set_column_width (GTK_CLIST (effects_list), 1, 80);
  gtk_clist_column_titles_hide (GTK_CLIST (effects_list));

  label16 = gtk_label_new ("label16");
  gtk_object_set_data (GTK_OBJECT (effects_window), "label16", label16);
  gtk_widget_show (label16);
  gtk_clist_set_column_widget (GTK_CLIST (effects_list), 0, label16);

  label17 = gtk_label_new ("label17");
  gtk_object_set_data (GTK_OBJECT (effects_window), "label17", label17);
  gtk_widget_show (label17);
  gtk_clist_set_column_widget (GTK_CLIST (effects_list), 1, label17);

  parameter_box = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (effects_window), "parameter_box", parameter_box);
  gtk_widget_show (parameter_box);
  gtk_box_pack_start (GTK_BOX (hbox31), parameter_box, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (parameter_box), 8);

  button_box = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (effects_window), "button_box", button_box);
  gtk_widget_show (button_box);
  gtk_box_pack_start (GTK_BOX (vbox23), button_box, FALSE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (button_box), 8);

  ok_button = gtk_button_new_with_label ("OK");
  gtk_object_set_data (GTK_OBJECT (effects_window), "ok_button", ok_button);
  gtk_widget_show (ok_button);
  gtk_box_pack_end (GTK_BOX (button_box), ok_button, FALSE, TRUE, 0);
  gtk_widget_set_usize (ok_button, 80, -2);

  return effects_window;
}

GtkWidget*
create_scopes_window ()
{
  GtkWidget *scopes_window;
  GtkWidget *vbox22;
  GtkWidget *scopes_list_box;
  GtkWidget *scrolledwindow3;
  GtkWidget *scopes_list;
  GtkWidget *label14;
  GtkWidget *label15;
  GtkWidget *hbox32;
  GtkWidget *ok_button;

  scopes_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (scopes_window), "scopes_window", scopes_window);
  gtk_window_set_title (GTK_WINDOW (scopes_window), "Scopes");

  vbox22 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (scopes_window), "vbox22", vbox22);
  gtk_widget_show (vbox22);
  gtk_container_add (GTK_CONTAINER (scopes_window), vbox22);

  scopes_list_box = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (scopes_window), "scopes_list_box", scopes_list_box);
  gtk_widget_show (scopes_list_box);
  gtk_box_pack_start (GTK_BOX (vbox22), scopes_list_box, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (scopes_list_box), 8);

  scrolledwindow3 = gtk_scrolled_window_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (scopes_window), "scrolledwindow3", scrolledwindow3);
  gtk_widget_show (scrolledwindow3);
  gtk_box_pack_start (GTK_BOX (scopes_list_box), scrolledwindow3, FALSE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow3), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  scopes_list = gtk_clist_new (2);
  gtk_object_set_data (GTK_OBJECT (scopes_window), "scopes_list", scopes_list);
  gtk_widget_show (scopes_list);
  gtk_container_add (GTK_CONTAINER (scrolledwindow3), scopes_list);
  gtk_widget_set_usize (scopes_list, 150, 180);
  gtk_clist_set_column_width (GTK_CLIST (scopes_list), 0, 49);
  gtk_clist_set_column_width (GTK_CLIST (scopes_list), 1, 80);
  gtk_clist_column_titles_hide (GTK_CLIST (scopes_list));

  label14 = gtk_label_new ("label14");
  gtk_object_set_data (GTK_OBJECT (scopes_window), "label14", label14);
  gtk_widget_show (label14);
  gtk_clist_set_column_widget (GTK_CLIST (scopes_list), 0, label14);

  label15 = gtk_label_new ("label15");
  gtk_object_set_data (GTK_OBJECT (scopes_window), "label15", label15);
  gtk_widget_show (label15);
  gtk_clist_set_column_widget (GTK_CLIST (scopes_list), 1, label15);

  hbox32 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (scopes_window), "hbox32", hbox32);
  gtk_widget_show (hbox32);
  gtk_box_pack_start (GTK_BOX (vbox22), hbox32, FALSE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (hbox32), 8);

  ok_button = gtk_button_new_with_label ("OK");
  gtk_object_set_data (GTK_OBJECT (scopes_window), "ok_button", ok_button);
  gtk_widget_show (ok_button);
  gtk_box_pack_end (GTK_BOX (hbox32), ok_button, FALSE, TRUE, 0);
  gtk_widget_set_usize (ok_button, 80, -2);

  return scopes_window;
}

