/*
 * dir.c source file for extace
 * 
 * /GDK/GNOME sound (esd) system output display program
 * 
 * Copyright (C) 1998 by Michael Fullbright
 * Re-hacked to look good by The Rasterman
 * 
 * Hacked some more by Dave J. Andruczyk <dave@techdev.buffalostate.edu>
 * to be fully scalable with lots of new options, for tilting the axis's
 * and various other cool stuff.
 * 
 * This software comes under the GPL (GNU Public License)
 * You may freely copy,distribute etc. this as long as the source code
 * is made available for FREE.
 * 
 * No warranty is made or implied. You use this program at your own risk.
 */

#include <config.h>
#include <globals.h>
#include <protos.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <time.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk_imlib.h>


// See globals.h for variable declarations and DEFINES

gint dir_configure(GtkWidget *widget, GdkEventConfigure *event)
{
    if (dir_pixmap)
	gdk_pixmap_unref(dir_pixmap);

    dir_pixmap = gdk_pixmap_new(widget->window,
				widget->allocation.width,
				widget->allocation.height,
				-1);
    gdk_draw_rectangle (dir_pixmap,
			widget->style->black_gc,
			TRUE,
			0, 0,
			widget->allocation.width,
			widget->allocation.height);

    setup_dircontrol(widget);
    return TRUE;
}

gint dir_expose(GtkWidget *widget, GdkEventExpose *event)
{
    gdk_draw_pixmap(widget->window,
	    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
	    dir_pixmap,
	    event->area.x, event->area.y,
	    event->area.x, event->area.y,
	    event->area.width, event->area.height);

    return FALSE;


}

gint dir_save_state(GtkWidget *widget, GdkEventFocus *event)
{
    int x,y;
    if (!dir_win_present)
	return TRUE;
    if (!event->in)
    {
	gdk_window_get_root_origin((gpointer) dir_win_ptr->window, &x, &y);
	dir_x_origin = x+6;
	dir_y_origin = y+22;
    }

    return FALSE;
}



gint setup_dircontrol(GtkWidget *widget)
{
    // Top main circle (360 degrees)
    gdk_draw_arc(dir_pixmap,
		 widget->style->white_gc,
		 0,  /* FILLED */
		 0,
		 0,
		 widget->allocation.width,
		 widget->allocation.height,
		 0*64,
		 360*64);
    // Y axis "front half" arc, notice its "lighter" (180 degrees)
    gdk_draw_arc(dir_pixmap,
		 widget->style->white_gc,
		 0,  /* FILLED */
		 .33*widget->allocation.width,
		 0,
		 .33*widget->allocation.width,
		 widget->allocation.height,
		 90*64,
		 180*64);
    // Y axis "back half" arc, notice its "darker" (180 degrees)
    gdk_draw_arc(dir_pixmap,
		 arc_gc,
		 0,  /* FILLED */
		 .33*widget->allocation.width,
		 0,
		 .33*widget->allocation.width,
		 widget->allocation.height,
		 -90*64,
		 180*64);
    // Z axis "front half" arc, notice its "lighter" (180 degrees)
    gdk_draw_arc(dir_pixmap,
		 widget->style->white_gc,
		 0,  /* FILLED */
		 0,
		 .33*widget->allocation.height,
		 widget->allocation.width,
		 .33*widget->allocation.height,
		 0*64,
		 -180*64);
    // Z axis "back half" arc, notice its "darker" (180 degrees)
    gdk_draw_arc(dir_pixmap,
		 arc_gc,
		 0,  /* FILLED */
		 0,
		 .33*widget->allocation.height,
		 widget->allocation.width,
		 .33*widget->allocation.height,
		 0*64,
		 180*64);
    return TRUE;
}
gint dir_motion (GtkWidget *widget, GdkEventMotion *event)
{
    int x, y;
    GdkModifierType state;

    if (event->is_hint)
    {
	gdk_window_get_pointer (event->window, &x, &y, &state);
    }
    else
    {
	x = event->x;
	y = event->y;
	state = event->state;
    }

    if (state & GDK_BUTTON1_MASK)
    {
	feed_pointer(x,y);     //call checking function
	dir_configure(dir_area, NULL);
	update_pointer();

    }
    return TRUE;
}

gint feed_pointer(gint x, gint y)
{
    float x_percent;
    float z_percent;
    x_percent = 100*((float)x/(float)dir_area->allocation.width);
    z_percent = 100*((float)y/(float)dir_area->allocation.height);
    switch (mode)
    {
	case (LAND_3D):
	    {
		if (z_percent < 50)
		    z3d_scroll = (50 - z_percent)*0.5;
		else
		    z3d_scroll = -(z_percent-50)*0.5;

		if (x_percent < 50)
		    x3d_scroll = (50 - x_percent)*0.5;
		else
		    x3d_scroll = -(x_percent-50)*0.5;
		/* Removed from control panel
		GTK_ADJUSTMENT (x3d_scroll_ptr)->value = x3d_scroll;
		GTK_ADJUSTMENT (z3d_scroll_ptr)->value = z3d_scroll;
		gtk_adjustment_value_changed(GTK_ADJUSTMENT (x3d_scroll_ptr));
		gtk_adjustment_value_changed(GTK_ADJUSTMENT (z3d_scroll_ptr));
		*/
		break;
	    }
	case (SPIKE_3D):
	    {
		if (z_percent < 50)
		    zdet_scroll = (50 - z_percent)*0.5;
		else
		    zdet_scroll = -(z_percent-50)*0.5;

		if (x_percent < 50)
		    xdet_scroll = (50 - x_percent)*0.5;
		else
		    xdet_scroll = -(x_percent-50)*0.5;
		/* Removed from control panel
		GTK_ADJUSTMENT (xdet_scroll_ptr)->value = xdet_scroll;
		GTK_ADJUSTMENT (zdet_scroll_ptr)->value = zdet_scroll;
		gtk_adjustment_value_changed(GTK_ADJUSTMENT (xdet_scroll_ptr));
		gtk_adjustment_value_changed(GTK_ADJUSTMENT (zdet_scroll_ptr));
		*/
		break;
	    }
    }
    return 0;
}

gint update_pointer()
{

    switch (mode)
    {
	case (LAND_3D):
	    {
		x_disp = ((float)x3d_scroll/25.0)*((float)dir_area->allocation.width/2.0);
		y_disp = ((float)z3d_scroll/25.0)*((float)dir_area->allocation.height/2.0);
		break;
	    }
	case (SPIKE_3D):
	    {
		x_disp = ((float)xdet_scroll/25.0)*((float)dir_area->allocation.width/2.0);
		y_disp = ((float)zdet_scroll/25.0)*((float)dir_area->allocation.height/2.0);
		break;
	    }
    }
    
    gdk_draw_line(dir_pixmap,
		  dir_area->style->white_gc,
		  dir_area->allocation.width/2, //center
		  dir_area->allocation.height/2, //center
		  dir_area->allocation.width/2-x_disp,
		  dir_area->allocation.height/2-y_disp);


    gdk_draw_pixmap(dir_area->window,
		    dir_area->style->fg_gc[GTK_WIDGET_STATE (dir_area)],
		    dir_pixmap,
		    0,0,
		    0,0,
		    dir_area->allocation.width,
		    dir_area->allocation.height);

    return 0;
}
