
 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission is hereby granted, free of charge, to use and distribute */
 /*  this software and its documentation without restriction, including  */
 /*  without limitation the rights to use, copy, modify, merge, publish, */
 /*  distribute, sublicense, and/or sell copies of this work, and to     */
 /*  permit persons to whom this work is furnished to do so, subject to  */
 /*  the following conditions:                                           */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*   4. The authors' names are not used to endorse or promote products  */
 /*      derived from this software without specific prior written       */
 /*      permission.                                                     */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/


#ifndef __EST_TSORTABLE_I_H__
#define __EST_TSORTABLE_I_H__

/** Instantiate rules for sortable template.
  * 
  * @author Richard Caley <rjc@cstr.ed.ac.uk>
  * @version $Id: EST_TSortableI.h,v 1.3 1999/05/30 13:52:10 awb release $
  */


// Instantiation Macros

#define Instantiate_TSortable_T(TYPE, TAG) \
	template class EST_TSortable<TYPE>; \
	template class EST_TSortable<TYPE *>; \
	\
	template void sort(EST_TList<TYPE> &, bool (*gt)(const EST_UItem *, const EST_UItem *)); \
	template void qsort(EST_TList<TYPE> &, bool (*gt)(const EST_UItem *, const EST_UItem *)); \
	template void ptr_sort(EST_TList<TYPE> &a); \
	template void ptr_qsort(EST_TList<TYPE> &a); \
	template void sort_unique(EST_TList<TYPE> &a); \
	template void merge_sort_unique(EST_TList<TYPE> &l, EST_TList<TYPE> &m); \
	\
	template bool operator==(const EST_TList<TYPE> &a, const EST_TList<TYPE> &b);

#define Instantiate_TSortable(TYPE) Instantiate_TSortable_T(TYPE, TYPE)

#define Declare_TSortable_T(TYPE,TAG) 

#define Declare_TSortable_Base_T(TYPE,DEFAULT,ERROR,TAG)

#define Declare_TSortable_Class_T(TYPE,DEFAULT,ERROR,TAG)

#define Declare_TSortable(TYPE) Declare_TSortable_T(TYPE,TYPE)

#define Declare_TSortable_Base(TYPE,DEFAULT,ERROR)  Declare_TSortable_Base_T(TYPE,DEFAULT,ERROR,TYPE)
#define Declare_TSortable_Class(TYPE,DEFAULT,ERROR) Declare_TSortable_Class_T(TYPE,DEFAULT,ERROR,TYPE)

#endif

