/* Gtick  -  A Gtk+ Metronome
 *
 *   main.c: Main app code
 *
 * Copyright (c) 1999, Alex Roberts
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <stdio.h>
#include "gtick.h"

TikTok *gtick;
static int running = 0;
int rate;

void gtQuit (GtkWidget *w, GtkWidget *window)
{
	gtk_widget_destroy (window);
	gtk_main_quit ();
}

void gtAdjVol (GtkWidget *widget, gpointer data)
{
	TikTok *ticker = (TikTok *)data;
	gint vol;
	
	vol = -(-100 - GTK_ADJUSTMENT(ticker->vAdj)->value);
	
	gtSetMixer (vol);
}

gint gtVolTimeout (gpointer data)
{
	TikTok *ticker = (TikTok *)data;
	
	gtk_adjustment_set_value(GTK_ADJUSTMENT(ticker->vAdj), 
	                         (gfloat)(-100 + gtGetMixer()));
	                         
	gtAdjVol (NULL, data);
	
	return 1;
}

gint gtTick (gpointer data)
{
TikTok *ticker = (TikTok *)data;

	if (GTK_TOGGLE_BUTTON (ticker->btn0)->active)
	  {
	    gtDSPTick (1);
	  }
	  
	if ((GTK_TOGGLE_BUTTON (ticker->btn24)->active))
	  gtDSPTick (2);
	  
	if ((GTK_TOGGLE_BUTTON (ticker->btn34)->active))
	  gtDSPTick (3);
	  
	if ((GTK_TOGGLE_BUTTON (ticker->btn44)->active))
	  gtDSPTick (4);	  

	return TRUE;
}

void gtUpdateRate (TikTok *tick, gpointer data)
{
TikTok *ticker = (TikTok *)data;

	if (ticker->ticking)
	  {
	    gtk_timeout_remove (running);
	    running = 0;
	  }	    
	    
	    rate = 1000/((GTK_ADJUSTMENT(ticker->adjustment)->value)/60.0);

#ifdef DEBUG	     
	    g_print ("gtUpdateRate: rate=%f running at %d ms\n",
	      			(GTK_ADJUSTMENT(ticker->adjustment)->value),rate);
#endif

	if (ticker->ticking)
	  {
	    running = gtk_timeout_add (rate, (GtkFunction) gtTick, 
								(TikTok *)ticker);
	  }	
	  
}

void gtBeat (TikTok *tick, gpointer data)
{
TikTok *ticker = (TikTok *)data;
  
	if (!ticker->ticking)
	  {
	    gtk_frame_set_label (GTK_FRAME(ticker->box3), "Ticker: On");
	    ticker->ticking = TRUE;
	    
	    /* Do Metronome stuff */
	    running = gtk_timeout_add (rate, (GtkFunction) gtTick,
	    							(TikTok *)ticker);
	  }
	else
	  {
	    gtk_frame_set_label (GTK_FRAME(ticker->box3), "Ticker: Off");	  
	    ticker->ticking = FALSE;
	   
	    /* Stop all Metronome stuff */
	    gtk_timeout_remove (running);
	    running = 0;
	  }
}

void gtInit (TikTok *ticker)
{
	ticker->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

	gtk_signal_connect (GTK_OBJECT (ticker->window), "destroy",
			 		 GTK_SIGNAL_FUNC (gtQuit),
					 &ticker->window);

	gtk_window_set_title (GTK_WINDOW (ticker->window),TITLE);
	gtk_container_set_border_width (GTK_CONTAINER (ticker->window), 5);


	ticker->box1 = gtk_vbox_new (FALSE, 5);
	gtk_container_add (GTK_CONTAINER (ticker->window), ticker->box1);
	gtk_widget_show (ticker->box1);

/*-- Metronome UI Code*/
	ticker->box3 = gtk_frame_new ("Ticker: Off");
	gtk_container_add (GTK_CONTAINER (ticker->box1), ticker->box3);
	gtk_widget_show (ticker->box3);

	ticker->box4 = gtk_vbox_new (FALSE, 5);
	gtk_container_set_border_width (GTK_CONTAINER (ticker->box4), 10);
	gtk_container_add (GTK_CONTAINER (ticker->box3), ticker->box4);
	gtk_widget_show (ticker->box4);
	
	ticker->box2 = gtk_hbox_new (FALSE, 10);
	gtk_container_add (GTK_CONTAINER (ticker->box4), ticker->box2);
	gtk_widget_show (ticker->box2);

	ticker->label = gtk_label_new ("BPM:");
	gtk_box_pack_start (GTK_BOX (ticker->box2), ticker->label, TRUE, TRUE, 0);
	gtk_widget_show (ticker->label);

	ticker->adjustment = gtk_adjustment_new (75.0, 30.0, 251.0, 1.0, 1.0, 1.0);
	gtk_signal_connect (GTK_OBJECT (ticker->adjustment), "value_changed",
					GTK_SIGNAL_FUNC (gtUpdateRate),
					(TikTok *)ticker);
                            
	gtUpdateRate (ticker,(TikTok *)ticker); /* Set initial rate */

	ticker->scale = gtk_hscale_new (GTK_ADJUSTMENT (ticker->adjustment));
	gtk_widget_set_usize (GTK_WIDGET (ticker->scale), 150, 30);
	gtk_range_set_update_policy (GTK_RANGE (ticker->scale), GTK_UPDATE_DELAYED);
	gtk_scale_set_digits (GTK_SCALE (ticker->scale), 1);
	gtk_scale_set_draw_value (GTK_SCALE (ticker->scale), TRUE);
	gtk_box_pack_start (GTK_BOX (ticker->box2), ticker->scale, TRUE, TRUE, 0);
	gtk_widget_show (ticker->scale);


	ticker->box2 = gtk_hbox_new (FALSE, 10);
	gtk_container_add (GTK_CONTAINER (ticker->box4), ticker->box2);
	gtk_widget_show (ticker->box2);

	ticker->label = gtk_label_new ("Volume:");
	gtk_box_pack_start (GTK_BOX (ticker->box2), ticker->label, TRUE, TRUE, 0);
	gtk_widget_show (ticker->label);
		
	ticker->vAdj = gtk_adjustment_new (-50, -100.0, 0.0, 50.0, 25.0, 0.0);
	gtk_signal_connect (GTK_OBJECT (ticker->vAdj), "value_changed",
					GTK_SIGNAL_FUNC (gtAdjVol),
					(TikTok *)ticker);	
	gtk_adjustment_set_value(GTK_ADJUSTMENT(ticker->vAdj), 
	                         (gfloat)(-100 + gtGetMixer()));
	ticker->vol = gtk_hscale_new (GTK_ADJUSTMENT(ticker->vAdj));
	gtk_widget_set_usize (GTK_WIDGET (ticker->vol), 150, 30);
	gtk_range_set_update_policy (GTK_RANGE (ticker->vol), GTK_UPDATE_CONTINUOUS);
	gtk_scale_set_digits (GTK_SCALE (ticker->vol), 0);
	gtk_scale_set_draw_value (GTK_SCALE (ticker->vol), FALSE);
	gtk_box_pack_start (GTK_BOX (ticker->box2), ticker->vol, TRUE, TRUE, 0);
	gtk_widget_show (ticker->vol);
	
/*-----------*/

/*-- Timing UI Code*/
	ticker->count = 0;		/* No Timing
						 *
						 * 1 = None
						 * 2 = 2/4
						 * 3 = 3/4
						 * 4 = 4/4
						 */

	ticker->box4 = gtk_frame_new ("Timing");
	gtk_container_add (GTK_CONTAINER (ticker->box1), ticker->box4);
	gtk_widget_show (ticker->box4);
      
	ticker->box2 = gtk_hbox_new (FALSE,0);
	gtk_container_set_border_width (GTK_CONTAINER (ticker->box2), 10);
	gtk_container_add (GTK_CONTAINER (ticker->box4), ticker->box2);
	gtk_widget_show (ticker->box2);
      
	ticker->btn0 = gtk_radio_button_new_with_label (NULL, "None");
	gtk_box_pack_start (GTK_BOX (ticker->box2), ticker->btn0, TRUE, TRUE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ticker->btn0), TRUE);
	gtk_widget_show (ticker->btn0); 
               
	ticker->btn24 = gtk_radio_button_new_with_label (
					gtk_radio_button_group (
						GTK_RADIO_BUTTON (ticker->btn0)),
						"2/4");
	gtk_box_pack_start (GTK_BOX (ticker->box2), ticker->btn24, TRUE, TRUE, 0);
	gtk_widget_show (ticker->btn24);
        
	ticker->btn34 = gtk_radio_button_new_with_label (
					gtk_radio_button_group (
						GTK_RADIO_BUTTON (ticker->btn0)),
						"3/4");
	gtk_box_pack_start (GTK_BOX (ticker->box2), ticker->btn34, TRUE, TRUE, 0);
	gtk_widget_show (ticker->btn34);

	ticker->btn44 = gtk_radio_button_new_with_label (
					gtk_radio_button_group (
						GTK_RADIO_BUTTON (ticker->btn0)), 
						"4/4");
	gtk_box_pack_start (GTK_BOX (ticker->box2), ticker->btn44, TRUE, TRUE, 0);
	gtk_widget_show (ticker->btn44);
/*-----------*/

/*-- General UI Code*/
	ticker->separator = gtk_hseparator_new ();
	gtk_box_pack_start (GTK_BOX (ticker->box1), ticker->separator, FALSE,TRUE,0);
	gtk_widget_show (ticker->separator);

	ticker->box2 = gtk_hbox_new (FALSE, 10);
	gtk_container_set_border_width (GTK_CONTAINER (ticker->box2), 5);
	gtk_box_pack_start (GTK_BOX (ticker->box1), ticker->box2, FALSE, TRUE, 0);
	gtk_widget_show (ticker->box2);

	ticker->togglebtn = gtk_button_new_with_label (" Toggle Ticker ");
	gtk_signal_connect (GTK_OBJECT (ticker->togglebtn), "clicked",
					GTK_SIGNAL_FUNC (gtBeat),
					(TikTok *)ticker);
				 
	gtk_box_pack_start (GTK_BOX (ticker->box2), ticker->togglebtn, TRUE,TRUE,0);
	GTK_WIDGET_SET_FLAGS (ticker->togglebtn, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (ticker->togglebtn);
	gtk_widget_show (ticker->togglebtn);

	ticker->button = gtk_button_new_with_label (" About ");
	gtk_signal_connect (GTK_OBJECT (ticker->button), "clicked",
					GTK_SIGNAL_FUNC (gtAboutBox),
					NULL);
				 
	gtk_box_pack_start (GTK_BOX (ticker->box2), ticker->button, TRUE, TRUE, 0);
	gtk_widget_show (ticker->button);

	ticker->button = gtk_button_new_with_label (" Quit ");
	gtk_signal_connect_object (GTK_OBJECT (ticker->button), "clicked",
							GTK_SIGNAL_FUNC (gtQuit),
							GTK_OBJECT (ticker->window));
				 		 
	gtk_box_pack_start (GTK_BOX (ticker->box2), ticker->button, TRUE,TRUE,0);
	gtk_widget_show (ticker->button);

      	gtk_widget_show (gtick->window);

/*-----------*/
}

int main()
{
/*
gint voltimeout
*/
	/* Initialise GTK+ */
	gtk_init (NULL,NULL);

	/* Initialise /dev/dsp */ 
        if ((gtInitDSP ()) == -1)
          {
            exit (1);
          }

	/* Initialise /dev/mixer */
	gtInitMixer ();

	gtick = g_malloc (sizeof (TikTok));
	
	/* Initialise UI */
	gtInit (gtick);
/*
	voltimeout = gtk_timeout_add (50, gtVolTimeout, (TikTok *)gtick);
  */   	
        gtk_main ();
      
        /* Shut down /dev/dsp and /dev/mixer and end program */
        gtCloseDSP ();
        gtCloseMixer();
        
        g_free (gtick);
        return 0;
}