/* connection.h
 * - Connection Function Headers
 *
 * Copyright (c) 1999 Jack Moffitt, Barath Raghavan, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __ICECAST_CONNECTION_H
#define __ICECAST_CONNECTION_H

void *handle_connection(void *data);
void close_connection(void *data, void *param);
connection_t *get_connection(int *sock);
connection_t *create_connection();
void describe_connection (const com_request_t *req, const connection_t *describecon);
const char *get_user_agent (connection_t *con);
void build_con_line_with_opts (connection_t *con, char *line, int *opt, int maxlen);
void build_source_con_line_with_opts (connection_t *con, char *line, int *opt, int maxlen);

#endif
