// filename.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// FileName is an abstract class with only static member functions.  All these
// functions perform operations upon or create file names.

#ifndef FILENAME_H
#ifdef __GNUG__
#pragma interface
#endif
#define FILENAME_H

#include "localdefs.h"

class FileName {
public:
	static const char* tmpName(const char* suffix);
	static const char* untitledName(const char* suffix);
	static const char* segmentName(const char* name, double, double);
	static boolean isTempName(const char* name);
	static boolean isFullPathName(const char* name);
	static const char* sfName(const char* filename);
	static const char* stripPath(const char* filename);
	static const char* changeSuffix(const char* name, const char* suffix);
	static FileType fileType(const char *filename);
private:
	static int tmpCount;
	static int untitledCount;
    virtual void dontAllowInstantiation()=0;
};

#endif
