#ifndef SND_0_H_LOADED
#define SND_0_H_LOADED

#if (!defined(HAVE_CONFIG_H))
  /* we need fstatfs -- need its header and how many args it takes */
  #if defined(SGI) || defined(SCO5) || defined(UW2) || defined(SOLARIS)
    #define HAVE_SYS_STATFS_H
    #define FSTATFS_ARGS 4
  #else
    #if defined(HPUX) || defined(LINUX) || defined(NEXT)
      #define HAVE_SYS_VFS_H
      #define FSTATFS_ARGS 2
    #else
      #if defined(ALPHA)
        #define HAVE_SYS_MOUNT_H
        #define FSTATFS_ARGS 2
      #else
        #if defined(WINDOZE) && defined(__CYGWIN__)
          #define HAVE_SYS_VFS_H
          #define FSTATFS_ARGS 2
        #endif
      #endif
    #endif
  #endif
  #ifdef __CYGWIN__
    #define CLOSEDIR_VOID
    /* apparently we can't trust the return value */
  #endif
  #if defined(LINUX) && (!(defined(NO_FPU_CONTROL_H)))
    #define HAVE_FPU_CONTROL_H 1
  #endif
  #define TRAP_SEGFAULT 1
  #ifdef __GNUC__
    #define HAVE_MALLINFO 1
  #endif
#endif

#ifndef FSTATFS_ARGS
  #define FSTATFS_ARGS 2
#endif

#if defined(CCRMA) && (!(defined(SND_CONF)))
  #define SND_CONF "/etc/snd.conf"
#endif

#define XOR(a,b) ((~((a) & (b))) & ((a) | (b)))

#define FILE_BUFFER_SIZE 8192
#define MAX_BUFFER_SIZE 65536
#define MIX_FILE_BUFFER_SIZE 2048

#define SCROLLBAR_MAX 100       /* used by zx, zy but not sx (huge files need special handling) or sy (tiny motions needed here too) */
#define SCROLLBAR_SY_MAX 500
#define SCROLLBAR_MID 50
#define SCROLLBAR_LINEAR_MAX 15
#define SCROLLBAR_LINEAR_MULT 0.011584929

enum {AMPLITUDE_ENV,SPECTRUM_ENV,SRATE_ENV};

#define NO_COMPLETER -1

#define DEFAULT_OUTPUT_TYPE NeXT_sound_file

#define NO_SELECTION -1

enum {AXIS_INFO,FILE_INFO,FFT_INFO,CHAN_INFO,SND_INFO,SND_STATE,REGION_INFO,UNKNOWN_TYPE};
enum {GRAPH_LINES,GRAPH_DOTS,GRAPH_FILLED,GRAPH_DOTS_AND_LINES,GRAPH_LOLLIPOPS};
enum {NORMAL_FFT,SONOGRAM,SPECTROGRAM};
enum {NOGRAPH,WAVE,FFT,LISP,FFT_MAIN};    /* for marks, regions, mouse click detection */
enum {ARRAY_USAGE,TEMP_USAGE,FILE_USAGE,TEMPS_ACTIVE,TEMPS_OPEN,ARRAYS_ACTIVE};
enum {FOCUS_LEFT,FOCUS_RIGHT,FOCUS_ACTIVE,FOCUS_MIDDLE};
enum {DONT_LOCK_MIXES,LOCK_MIXES};
enum {DONT_DELETE_ME,DELETE_ME};
enum {PLAIN_MESSAGE,MESSAGE_WITH_CARET,MESSAGE_WITHOUT_CARET};

#define NO_REGIONS -1
#define INVALID_REGION -2

#ifdef NEXT
  #define S_ISDIR(mode) (((mode) & S_IFMT) == S_IFDIR)
  #define S_ISLNK(mode) (((mode) & S_IFMT) == S_IFLNK)
#endif

#define READ_FORWARD 1
#define READ_BACKWARD -1

#define FOLLOW_ALWAYS 1
#define FOLLOW_ONCE 2
#define DONT_FOLLOW 0

#define UPDATE_DISPLAY 1
#define DONT_UPDATE_DISPLAY 0

#define FROM_ENVED 1
#define NOT_FROM_ENVED 0

#define FILE_EXISTS 1
#define FILE_DOES_NOT_EXIST 0

enum {X_IN_SECONDS,X_IN_SAMPLES,X_TO_ONE,X_IN_LENGTH};
enum {SPEED_AS_FLOAT,SPEED_AS_RATIO,SPEED_AS_SEMITONE};

enum {MD_CS,MD_TITLE,MD_M};

enum {CURSOR_IN_VIEW,CURSOR_ON_LEFT,CURSOR_ON_RIGHT,CURSOR_IN_MIDDLE,
      CURSOR_UPDATE_DISPLAY,CURSOR_NO_ACTION,CURSOR_CLAIM_SELECTION,KEYBOARD_NO_ACTION};
enum {SEARCH_TREE,EVAL_TREE};

enum {GROUP_INITIALIZED,GROUP_ACTIVE,GROUP_CLEARED};
enum {NO_PROBLEM,BLIND_LEAP,GIVE_UP,HUNKER_DOWN};
enum {CHANNELS_SEPARATE,CHANNELS_COMBINED,CHANNELS_SUPERIMPOSED};
enum {FD_INITIALIZED,FD_OPEN,FD_CLOSED};
enum {PRINT_SND,PRINT_ENV};

#define SND_DATA_FILE 0
#define SND_DATA_BUFFER 1

enum {SOUNDS_VERTICAL,SOUNDS_HORIZONTAL,SOUNDS_IN_NOTEBOOK,SOUNDS_IN_SCROLLER,SOUNDS_IN_SEPARATE_WINDOWS};
enum {FOURIER,WAVELET,HANKEL,WALSH,AUTOCORRELATION,CHEBYSHEV,LEGENDRE,HADAMARD};

enum {AUTOLOAD,REC_IN_AMPS,REC_OUT_AMPS,AUDIO_GAINS,REC_SRATE,IN_FORMAT,OUT_CHANS,OUT_FORMAT};

enum {NOT_FILING,INPUT_FILING,REGION_FILING,CHANNEL_FILING,TEMP_FILING,CHANGE_FILING,INSERT_FILING,MACRO_FILING};
enum {APPLY_TO_SOUND,APPLY_TO_CHANNEL,APPLY_TO_SELECTION};
enum {LISTENER_CLOSED,LISTENER_OPEN,LISTENER_LISTENING};

enum {SND_NO_ERROR,SND_CANNOT_WRITE_HEADER,SND_CANNOT_OPEN_TEMP_FILE,
      SND_CANNOT_ALLOCATE_IO_BUFFERS,SND_CANNOT_WRITE_DATA,
      SND_CANNOT_REMOVE_FILE,SND_CANNOT_RENAME_FILE,
      SND_CANNOT_READ_HEADER,SND_UNSUPPORTED_HEADER_TYPE,
      SND_CANNOT_FIND_FILE,SND_UNSUPPORTED_DATA_FORMAT,
      SND_PENDING_OPEN};

enum {SND_NO_EVAL_ERROR,SND_NO_SUCH_MIX,SND_NO_SUCH_CHANNEL,SND_NO_SUCH_SOUND,SND_NO_SUCH_MARK,
      SND_NO_SUCH_GROUP,SND_NO_SUCH_REGION,SND_NO_ACTIVE_SELECTION,SND_NO_SUCH_FILE,SND_NO_SUCH_MENU,
      SND_NO_SUCH_SAMPLE,SND_MISCELLANEOUS_ERROR};

#define NEXT_POSITION 1
#define AIFC_POSITION 2
#define RIFF_POSITION 3
#define RAW_POSITION 4
#define AIFF_POSITION 5
#define IRCAM_POSITION 6
#define NIST_POSITION 7

#define NO_CHANGE 0
#define JUST_AMP 1
#define JUST_SPEED 2
#define ALL_CHANGES 3

enum {SCAN_CURRENT_CHAN,SCAN_SOUND_CHANS,SCAN_SYNCD_CHANS,SCAN_ALL_CHANS};
#define MIXER_SAVE_STATE_FILE ".snd-mixer"


/* ---------------- USER-VISIBLE VARIABLE NAMES ---------------- */

#if HAVE_GUILE
  #include <guile/gh.h>
#endif

  #define default_amp(ss) ss->Default_Amp
  #define set_default_amp(ss,a) ss->Default_Amp = a

  #define default_contrast(ss) ss->Default_Contrast
  #define set_default_contrast(ss,a) ss->Default_Contrast = a

  #define default_contrast_amp(ss) ss->Default_Contrast_Amp
  #define set_default_contrast_amp(ss,a) ss->Default_Contrast_Amp = a

  #define default_contrasting(ss) ss->Default_Contrasting
  #define set_default_contrasting(ss,a) ss->Default_Contrasting = a

  #define default_expand(ss) ss->Default_Expand
  #define set_default_expand(ss,a) ss->Default_Expand = a

  #define default_expanding(ss) ss->Default_Expanding
  #define set_default_expanding(ss,a) ss->Default_Expanding = a

  #define default_expand_hop(ss) ss->Default_Expand_Hop
  #define set_default_expand_hop(ss,a) ss->Default_Expand_Hop = a

  #define default_expand_length(ss) ss->Default_Expand_Length
  #define set_default_expand_length(ss,a) ss->Default_Expand_Length = a

  #define default_expand_ramp(ss) ss->Default_Expand_Ramp
  #define set_default_expand_ramp(ss,a) ss->Default_Expand_Ramp = a

  #define default_filtering(ss) ss->Default_Filtering
  #define set_default_filtering(ss,a) ss->Default_Filtering = a

  #define default_filter_order(ss) ss->Default_Filter_Order
  #define in_set_default_filter_order(ss,a) ss->Default_Filter_Order = a

  #define default_filter_dBing(ss) ss->Default_Filter_dBing
  #define set_default_filter_dBing(ss,a) ss->Default_Filter_dBing = a

  #define default_reverbing(ss) ss->Default_Reverbing
  #define set_default_reverbing(ss,a) ss->Default_Reverbing = a

  #define reverb_decay(ss) ss->Reverb_Decay
  #define set_reverb_decay(ss,a) ss->Reverb_Decay = a

  #define default_reverb_feedback(ss) ss->Default_Reverb_Feedback
  #define set_default_reverb_feedback(ss,a) ss->Default_Reverb_Feedback = a

  #define default_reverb_length(ss) ss->Default_Reverb_Length
  #define set_default_reverb_length(ss,a) ss->Default_Reverb_Length = a

  #define default_reverb_lowpass(ss) ss->Default_Reverb_Lowpass
  #define set_default_reverb_lowpass(ss,a) ss->Default_Reverb_Lowpass = a

  #define default_reverb_scale(ss) ss->Default_Reverb_Scale
  #define set_default_reverb_scale(ss,a) ss->Default_Reverb_Scale = a

  #define default_speed(ss) ss->Default_Speed
  #define set_default_speed(ss,a) ss->Default_Speed = a

  #define default_output_type(ss) ss->Default_Output_Type
  #define set_default_output_type(ss,a) ss->Default_Output_Type = a

  #define normalize_on_open(ss) ss->Normalize_On_Open
  #define set_normalize_on_open(ss,a) ss->Normalize_On_Open = a

  #define dac_size(ss) ss->Dac_Size
  #define set_dac_size(ss,a) ss->Dac_Size = a

  #define max_regions(ss) ss->Max_Regions
  #define in_set_max_regions(ss,a) ss->Max_Regions = a

  #define max_fft_peaks(ss) ss->Max_Fft_Peaks
  #define in_set_max_fft_peaks(ss,a) ss->Max_Fft_Peaks = a

  #define max_fft_size(ss) ss->Max_Fft_Size
  #define set_max_fft_size(ss,a) ss->Max_Fft_Size = a

  #define auto_resize(ss) ss->Auto_Resize
  #define set_auto_resize(ss,a) ss->Auto_Resize = a

  #define auto_update(ss) ss->Auto_Update
  #define set_auto_update(ss,a) ss->Auto_Update = a

  #define corruption_time(ss) ss->Corruption_Time
  #define set_corruption_time(ss,a) ss->Corruption_Time = a

  #define color_cutoff(ss) ss->Color_Cutoff
  #define in_set_color_cutoff(ss,a) ss->Color_Cutoff = a

  #define color_inverted(ss) ss->Color_Inverted
  #define in_set_color_inverted(ss,a) ss->Color_Inverted = a

  #define color_scale(ss) ss->Color_Scale
  #define in_set_color_scale(ss,a) ss->Color_Scale = a

  #define fft_beta(ss) ss->Fft_Beta
  #define in_set_fft_beta(ss,a) ss->Fft_Beta = a

  #define fft_size(ss) ss->Fft_Size
  #define in_set_fft_size(ss,a) ss->Fft_Size = a

  #define fft_style(ss) ss->Fft_Style
  #define in_set_fft_style(ss,a) ss->Fft_Style = a

  #define fft_window(ss) ss->Fft_Window
  #define in_set_fft_window(ss,a) ss->Fft_Window = a

  #define trap_segfault(ss) ss->Trap_Segfault
  #define set_trap_segfault(ss,a) ss->Trap_Segfault = a

  #define initial_x0(ss) ss->Initial_X0
  #define set_initial_x0(ss,a) ss->Initial_X0 = a

  #define initial_x1(ss) ss->Initial_X1
  #define set_initial_x1(ss,a) ss->Initial_X1 = a

  #define initial_y0(ss) ss->Initial_Y0
  #define set_initial_y0(ss,a) ss->Initial_Y0 = a

  #define initial_y1(ss) ss->Initial_Y1
  #define set_initial_y1(ss,a) ss->Initial_Y1 = a

  #define line_size(ss) ss->Line_Size
  #define set_line_size(ss,a) ss->Line_Size = a

  #define dot_size(ss) ss->Dot_Size
  #define in_set_dot_size(ss,a) ss->Dot_Size = a

  #define normalize_fft(ss) ss->Normalize_Fft
  #define in_set_normalize_fft(ss,a) ss->Normalize_Fft = a

  #define ask_before_overwrite(ss) ss->Ask_Before_Overwrite
  #define set_ask_before_overwrite(ss,a) ss->Ask_Before_Overwrite = a

  #define spectro_cutoff(ss) ss->Spectro_Cutoff
  #define in_set_spectro_cutoff(ss,a) ss->Spectro_Cutoff = a

  #define spectro_x_angle(ss) ss->Spectro_X_Angle
  #define in_set_spectro_x_angle(ss,a) ss->Spectro_X_Angle = a

  #define spectro_y_angle(ss) ss->Spectro_Y_Angle
  #define in_set_spectro_y_angle(ss,a) ss->Spectro_Y_Angle = a

  #define spectro_z_angle(ss) ss->Spectro_Z_Angle
  #define in_set_spectro_z_angle(ss,a) ss->Spectro_Z_Angle = a

  #define spectro_x_scale(ss) ss->Spectro_X_Scale
  #define in_set_spectro_x_scale(ss,a) ss->Spectro_X_Scale = a

  #define spectro_y_scale(ss) ss->Spectro_Y_Scale
  #define in_set_spectro_y_scale(ss,a) ss->Spectro_Y_Scale = a

  #define spectro_z_scale(ss) ss->Spectro_Z_Scale
  #define in_set_spectro_z_scale(ss,a) ss->Spectro_Z_Scale = a

  #define spectro_hop(ss) ss->Spectro_Hop
  #define in_set_spectro_hop(ss,a) ss->Spectro_Hop = a

  #define color_map(ss) ss->Color_Map
  #define in_set_color_map(ss,a) ss->Color_Map = a

  #define speed_tones(ss) ss->Speed_Tones
  #define set_speed_tones(ss,a) ss->Speed_Tones = a

  #define speed_style(ss) ss->Speed_Style
  #define in_set_speed_style(ss,a) ss->Speed_Style = a

  #define graph_style(ss) ss->Graph_Style
  #define in_set_graph_style(ss,a) ss->Graph_Style = a

  #define sinc_width(ss) ss->Sinc_Width
  #define set_sinc_width(ss,a) ss->Sinc_Width = a

  #define mixer_groups(ss) ss->Mixer_Groups
  #define set_mixer_groups(ss,a) ss->Mixer_Groups = a

  #define mixer_group_max_out_chans(ss) ss->Mixer_Group_Max_Out_Chans
  #define set_mixer_group_max_out_chans(ss,a) ss->Mixer_Group_Max_Out_Chans = a

  #define verbose_cursor(ss) ss->Verbose_Cursor
  #define in_set_verbose_cursor(ss,a) ss->Verbose_Cursor = a

  #define movies(ss) ss->Movies
  #define set_movies(ss,a) ss->Movies = a

  #define prefix_arg(ss) ss->Prefix_Arg
  #define set_prefix_arg(ss,a) ss->Prefix_Arg = a

  #define filter_env_order(ss) ss->Filter_Env_Order
  #define in_set_filter_env_order(ss,a) ss->Filter_Env_Order = a

  #define save_state_on_exit(ss) ss->Save_State_On_Exit
  #define set_save_state_on_exit(ss,a) ss->Save_State_On_Exit = a

  #define zoom_focus_style(ss) ss->Zoom_Focus_Style
  #define set_zoom_focus_style(ss,a) ss->Zoom_Focus_Style = a

  #define fit_data_on_open(ss) ss->Fit_Data_On_Open
  #define set_fit_data_on_open(ss,a) ss->Fit_Data_On_Open = a

  #define eps_file(ss) ss->Eps_File
  #define set_eps_file(ss,a) ss->Eps_File = a

  #define mixer_save_state_file(ss) ss->Mixer_Save_State_File
  #define set_mixer_save_state_file(ss,a) ss->Mixer_Save_State_File = a

  #define save_state_file(ss) ss->Save_State_File
  #define in_set_save_state_file(ss,a) ss->Save_State_File = a

  #define temp_dir(ss) ss->Temp_Dir
  #define set_temp_dir(ss,a) ss->Temp_Dir = a

  #define vu_font(ss) ss->Vu_Font
  #define set_vu_font(ss,a) ss->Vu_Font = a

  #define vu_font_size(ss) ss->Vu_Font_Size
  #define set_vu_font_size(ss,a) ss->Vu_Font_Size = a

  #define vu_size(ss) ss->Vu_Size
  #define set_vu_size(ss,a) ss->Vu_Size = a

  #define wavelet_type(ss) ss->Wavelet_Type
  #define in_set_wavelet_type(ss,a) ss->Wavelet_Type = a

  #define transform_type(ss) ss->Transform_Type
  #define in_set_transform_type(ss,a) ss->Transform_Type = a

  #define show_selection_transform(ss) ss->Show_Selection_Transform
  #define in_set_show_selection_transform(ss,a) ss->Show_Selection_Transform = a

  #define wavo_hop(ss) ss->Wavo_Hop
  #define set_wavo_hop(ss,a) ss->Wavo_Hop = a

  #define wavo(ss) ss->Wavo
  #define in_set_wavo(ss,a) ss->Wavo = a

  #define wavo_trace(ss) ss->Wavo_Trace
  #define set_wavo_trace(ss,a) ss->Wavo_Trace = a

  #define x_axis_style(ss) ss->X_Axis_Style
  #define in_set_x_axis_style(ss,a) ss->X_Axis_Style = a

  #define xmax(ss) ss->Xmax
  #define set_xmax(ss,a) ss->Xmax = a

  #define xmin(ss) ss->Xmin
  #define set_xmin(ss,a) ss->Xmin = a

  #define ymax(ss) ss->Ymax
  #define set_ymax(ss,a) ss->Ymax = a

  #define ymin(ss) ss->Ymin
  #define set_ymin(ss,a) ss->Ymin = a

  #define zero_pad(ss) ss->Zero_Pad
  #define set_zero_pad(ss,a) ss->Zero_Pad = a

  #define show_fft_peaks(ss) ss->Show_Fft_Peaks
  #define in_set_show_fft_peaks(ss,a) ss->Show_Fft_Peaks = a

  #define show_y_zero(ss) ss->Show_Y_Zero
  #define in_set_show_y_zero(ss,a) ss->Show_Y_Zero = a

  #define show_axes(ss) ss->Show_Axes
  #define in_set_show_axes(ss,a) ss->Show_Axes = a

  #define show_usage_stats(ss) ss->Show_Usage_Stats
  #define in_set_show_usage_stats(ss,a) ss->Show_Usage_Stats = a

  #define show_mix_consoles(ss) ss->Show_Mix_Consoles
  #define in_set_show_mix_consoles(ss,a) ss->Show_Mix_Consoles = a

  #define show_mix_waveforms(ss) ss->Show_Mix_Waveforms
  #define in_set_show_mix_waveforms(ss,a) ss->Show_Mix_Waveforms = a

  #define mix_waveform_height(ss) ss->Mix_Waveform_Height
  #define in_set_mix_waveform_height(ss,a) ss->Mix_Waveform_Height = a

  #define show_marks(ss) ss->Show_Marks
  #define in_set_show_marks(ss,a) ss->Show_Marks = a

  #define fft_log_magnitude(ss) ss->Fft_Log_Magnitude
  #define in_set_fft_log_magnitude(ss,a) ss->Fft_Log_Magnitude = a

  #define fft_log_frequency(ss) ss->Fft_Log_Frequency
  #define in_set_fft_log_frequency(ss,a) ss->Fft_Log_Frequency = a

  #define channel_style(ss) ss->Channel_Style
  #define in_set_channel_style(ss,a) ss->Channel_Style = a

  #define sound_style(ss) ss->Sound_Style
  #define set_sound_style(ss,a) ss->Sound_Style = a

  #define listener_prompt(ss) ss->Listener_Prompt
  #define set_listener_prompt(ss,a) ss->Listener_Prompt = a

  #define raw_srate(ss) ss->Raw_Srate
  #define set_raw_srate(ss,a) ss->Raw_Srate = a

  #define raw_chans(ss) ss->Raw_Chans
  #define set_raw_chans(ss,a) ss->Raw_Chans = a

  #define raw_format(ss) ss->Raw_Format
  #define set_raw_format(ss,a) ss->Raw_Format = a

  #define raw_type(ss) ss->Raw_Type
  #define set_raw_type(ss,a) ss->Raw_Type = a

  #define use_raw_defaults(ss) ss->Use_Raw_Defaults
  #define set_use_raw_defaults(ss,a) ss->Use_Raw_Defaults = a

  #define print_length(ss) ss->Print_Length
  #define set_print_length(ss,a) ss->Print_Length = a

  #define previous_files_sort(ss) ss->Previous_Files_Sort
  #define set_previous_files_sort(ss,a) ss->Previous_Files_Sort = a

  #define enved_clipping(ss) ss->Enved_Clipping
  #define in_set_enved_clipping(ss,a) ss->Enved_Clipping = a

  #define enved_waving(ss) ss->Enved_Waving
  #define in_set_enved_waving(ss,a) ss->Enved_Waving = a

  #define enved_dBing(ss) ss->Enved_dBing
  #define in_set_enved_dBing(ss,a) ss->Enved_dBing = a

  #define enved_target(ss) ss->Enved_Target
  #define in_set_enved_target(ss,a) ss->Enved_Target = a

  #define enved_base(ss) ss->Enved_Base
  #define in_set_enved_base(ss,a) ss->Enved_Base = a

  #define enved_power(ss) ss->Enved_Power
  #define set_enved_power(ss,a) ss->Enved_Power = a

  #define enved_exping(ss) ss->Enved_Exping
  #define in_set_enved_exping(ss,a) ss->Enved_Exping = a

  #define recorder_autoload(ss) ss->Recorder_Autoload
  #define in_set_recorder_autoload(ss,a) ss->Recorder_Autoload = a

  #define recorder_file(ss) ss->Recorder_File
  #define in_set_recorder_file(ss,a) ss->Recorder_File = a

  #define recorder_buffer_size(ss) ss->Recorder_Buffer_Size
  #define in_set_recorder_buffer_size(ss,a) ss->Recorder_Buffer_Size = a

  #define recorder_in_format(ss) ss->Recorder_In_Format
  #define in_set_recorder_in_format(ss,a) ss->Recorder_In_Format = a

  #define recorder_srate(ss) ss->Recorder_Srate
  #define in_set_recorder_srate(ss,a) ss->Recorder_Srate = a

  #define recorder_trigger(ss) ss->Recorder_Trigger
  #define in_set_recorder_trigger(ss,a) ss->Recorder_Trigger = a

  #define recorder_max_duration(ss) ss->Recorder_Max_Duration
  #define in_set_recorder_max_duration(ss,a) ss->Recorder_Max_Duration = a

  #define recorder_out_format(ss) ss->Recorder_Out_Format
  #define in_set_recorder_out_format(ss,a) ss->Recorder_Out_Format = a

  #define recorder_out_chans(ss) ss->Recorder_Out_Chans
  #define in_set_recorder_out_chans(ss,a) ss->Recorder_Out_Chans = a

  #define audio_output_device(ss) ss->Audio_Output_Device
  #define set_audio_output_device(ss,a) ss->Audio_Output_Device = a

  #define show_edit_history(ss) ss->Show_Edit_History
  #define set_show_edit_history(ss,a) ss->Show_Edit_History = a

  #define edit_history_width(ss) ss->Edit_History_Width
  #define in_set_edit_history_width(ss,a) ss->Edit_History_Width = a

  #define in_graph_cursor(ss) ss->Graph_Cursor

#if HAVE_XmHTML
  #define html_width(ss) ss->HTML_Width
  #define set_html_width(ss,a) ss->HTML_Width = a

  #define html_height(ss) ss->HTML_Height
  #define set_html_height(ss,a) ss->HTML_Height = a

  #define html_dir(ss) ss->HTML_Dir
  #define set_html_dir(ss,a) ss->HTML_Dir = a

  #define html_font_size_list(ss) ss->HTML_Font_Size_List
  #define set_html_font_size_list(ss,a) ss->HTML_Font_Size_List = a

  #define html_fixed_font_size_list(ss) ss->HTML_Fixed_Font_Size_List
  #define set_html_fixed_font_size_list(ss,a) ss->HTML_Fixed_Font_Size_List = a
#endif
#endif


