#ifndef SNDIO_H_LOADED
#define SNDIO_H_LOADED

/* taken from libtool's demo/foo.h to try to protect us from C++ and ancient C's */
#undef __BEGIN_DECLS
#undef __END_DECLS
#ifdef __cplusplus
# define __BEGIN_DECLS extern "C" {
# define __END_DECLS }
#else
# define __BEGIN_DECLS /* empty */
# define __END_DECLS /* empty */
#endif

#undef __P
#if defined (__STDC__) || defined (_AIX) || (defined (__mips) && defined (_SYSTYPE_SVR4)) || defined(WIN32) || defined(__cplusplus)
# define __P(protos) protos
#else
# define __P(protos) ()
#endif

#define SND_CLM_FIFO "snd_clm_fifo"
#define CLM_SND_FIFO "clm_snd_fifo"

#define SND_IO_FD 1
#define SND_IO_CHANS 2
#define SND_IO_SIZE 3
#define SND_IO_BEG 4
#define SND_IO_END 5
#define SND_IO_BUFSIZ 6
#define SND_IO_DATA_START 7
#define SND_IO_DATA_END 8
#define SND_IO_DIR 10
#define SND_IO_LOC 11
#define SND_IO_HDR_END 12
#define SND_IO_INCR 13
#define SND_IO_DATS 14

#define SND_AREF_BLOCK 0
#define SND_AREF_SIZE 1
#define SND_AREF_HEADER_SIZE 2

#define SND_IO_IN_FILE 0
#define SND_IO_OUT_FILE 1

#define TWO_PI 6.283185307179586

__BEGIN_DECLS

void mus_file_reset __P((int loc0, int *io, int *datai));

/* fft.c is shared with Snd */
void c_fft __P((float* rl, float* im, int n, int isign, int ipow));
void convolve __P((float* rl1, float* rl2, int n, int ipow));
void c_convolve __P((char *fname, float amp, int filec, int filehdr,int filterc, int filterhdr, int filtersize,
		 int start, int fftsize, int ipow, int chans, int chan, int max_fft_size, int filter_chans, int filter_chan, int data_size));

__END_DECLS

#endif
