#ifndef LEDButton_h
#define LEDButton_h

#include <qbutton.h>
#include <qcolor.h>
#include <qpainter.h>
#include <qpixmap.h>

class LEDButton : public QButton
{
    Q_OBJECT
		
 public:

    enum LEDColour
    {
        green, red,
        none  // no LED
    };
	
    LEDButton(QWidget* parent=0, const char* name=0);
    ~LEDButton();

    void setColour(LEDColour);
    void setText(const char*);
    void setChecked(bool);
    bool isChecked() const;
    void setEnabled(bool);
    bool isEnabled() const;
    void toggle();
    
 private:

    void createPixmaps();
    void drawButton(QPainter*);
	
    QPixmap* onPixmap;
    QPixmap* offPixmap;
    QPixmap* disabledPixmap;

    QColor backgCol;
    LEDColour colour;
	
    bool bChecked, bEnabled;
};

#endif  // LEDButton_h
