
#include <fstream>

#include "map_repl.hh"
#include "map_repl_read.hh"

#include <algorithm>
#include <functional>

namespace afilter {

  struct CharCompare {
    typedef MapReplData::ToUnicode::value_type value_type;
    bool operator() (const value_type & rhs, const value_type & lhs) {
      return lexicographical_compare(rhs.first.begin(), rhs.first.end(),
				     lhs.first.begin(), lhs.first.end(),
				     less<char>());
    }
  };

  void get_map(MapReplData & from_data, MapReplData & to_data,
	       const ConfigData & opts, MapReplBase<char,char> & con)
  {
    MapReplData::ToUnicode   & to_uni = from_data.to_unicode;
    MapReplData::FromUnicode & from_uni = to_data.from_unicode;
    MapReplData::ToUnicode  ::iterator i;
    MapReplData::FromUnicode::iterator j;
    sort(to_uni.begin(), to_uni.end(), CharCompare());
    string to_word;
    for (i = to_uni.begin(); i != to_uni.end(); ++i) {
      j = lower_bound(from_uni.begin(), from_uni.end(), 
		      MapReplData::FromUniPair(i->second,""));
      if (j != from_uni.end() && j->first == i->second) {
	//cout << i->first.c_str() << " : " << j->second.c_str() << endl;
	con.add(i->first.c_str(), j->second.c_str());
      }
    }
  
    con.name_      = from_data.stats.name + "/" + to_data.stats.name;
    con.max_in_    = from_data.stats.max_size;
    con.max_out_   = to_data.stats.max_size;
    con.order_num_ = .75;
  }

  void get_map(MapReplData & data, const ConfigData & opts,
	       MapReplBase<char,unichar> & con) 
  {
    MapReplData::ToUnicode & to_uni = data.to_unicode;
    sort(to_uni.begin(), to_uni.end(), CharCompare());
    unichar to_word[2] = {0,0};
    MapReplData::ToUnicode::iterator i;
    for (i = to_uni.begin(); i != to_uni.end(); ++i) {
      to_word[0] = i->second;
      con.add(i->first.c_str(), to_word);
    }
    con.name_      = data.stats.name;
    con.max_in_    = data.stats.max_size;
    con.max_out_   = 1;
    con.order_num_ = .75;
  }


  void get_map(MapReplData & data, const ConfigData & opts,
	       MapReplBase<unichar,char> & con) 
  {
    MapReplData::FromUnicode & from_uni = data.from_unicode;
    unichar from_word[2] = {0,0};
    MapReplData::FromUnicode::iterator i;
    for (i = from_uni.begin(); i != from_uni.end(); ++i) {
      from_word[0] = i->first;
      con.add(from_word, i->second.c_str());
    }
    con.name_      = data.stats.name;
    con.max_in_    = 1;
    con.max_out_   = data.stats.max_size;
    con.order_num_ = .75;
  }

  bool get_map(const string & name, const ConfigData & opts, 
	       MapReplData & data) 
  {
    return read(name, opts, data, cerr, 0);
  }
}

#if 0
  bool get_direct_map(const string & from, const string & to,
		      const ConfigData & opts, 
		      MapReplData & from_data, MapReplData & to_data) 
  {
    return get_map(from, opts, from_data) &&
    
  }

#endif

