
#ifndef __repl_func__ 
#define __repl_func__ 

#include "repl-t.hh"

namespace afilter {

  template <class Filter, class Type>
  FilterItrPart * get_filter(const ConfigData * opts, const ReplOpts * lopts) {
    return new ReplItr<Filter>(opts, lopts);
  }

  template <class Filter, class Type>
  FilterItrPart * get_filter(const CharReplBase<Type> & r) {
    return new ReplItr<Filter>(r);
  }

  template <class Filter, class Type>
  CharReplBase<Type> *get_repl(const ConfigData * opts, 
			       const ReplOpts * lopts) 
  {
    return new Filter(opts,lopts);
  }
}

#define PARMS (const ConfigData *, const ReplOpts *)
#define GET_REPL(class,what)   \
  template CharReplBase<what> * get_repl<class<what>, what>   PARMS
#define GET_FILTER(class,what,a,b) \
  template FilterItrPart * get_filter<class<what>, what> PARMS;\
  template FilterItrPart * get_filter<class<what>, what> (const CharReplBase<what> &);\
  GET_REPL(class,what)
  
#define INST_char2char(class)     GET_FILTER(class,char2char, -1,-1)
#define INST_single2char(class)   GET_FILTER(class,char2char, 1, -1)
#define INST_char2single(class)   GET_FILTER(class,char2single, -1,1)
#define INST_single2single(class) GET_FILTER(class,char2single, 1,1)
#define INST_char2uni(class)   GET_REPL  (class,char2uni)
#define INST_single2uni(class) GET_REPL  (class,char2uni)
#define INST_uni2char(class)   GET_REPL  (class,uni2char)
#define INST_uni2single(class) GET_REPL  (class,uni2single)

#endif
