#ifndef _asuggest_hh_
#define _asuggest_hh_

#include "editdist.hh"
#include "bad_value.hh"

namespace aspell {
  class Manager;
  class Suggest;

  struct SuggestParms {
    EditDistanceWeights edit_distance_weights;

    int normal_soundslike_weight; // percentage
    int small_word_soundslike_weight; 
    int small_word_threshold;
    
    int soundslike_weight;
    int word_weight;

    int soundslike_level; // either one or 2
    
    int skip;
    int span;
    int limit;

    SuggestParms(const string & mode = "normal") {
      edit_distance_weights.del1 =  95;
      edit_distance_weights.del2 =  95;
      edit_distance_weights.swap =  90;
      edit_distance_weights.sub =  100;
      edit_distance_weights.similar = 10;
      edit_distance_weights.max = 100;
      edit_distance_weights.min =  90;

      normal_soundslike_weight = 50;
      small_word_soundslike_weight = 15;
      small_word_threshold = 4;

      soundslike_weight = normal_soundslike_weight;
      word_weight       = 100 - normal_soundslike_weight;
      
      skip = 2;
      limit = 100;
      if (mode == "normal") {
	soundslike_level = 2; // either one or two
	span = 75;
      } else if (mode == "fast") {
	soundslike_level = 1; // either one or two
	span = 50;
      } else if (mode == "bad-spellers") {
	normal_soundslike_weight = 55;
	small_word_threshold = 0;
	soundslike_level = 2; // either one or two
	span = 125;
	limit = 1000;
      } else {
	throw BadValue("sug-mode", mode, "one of fast, normal, or bad-spellers");
      }
    }

    virtual ~SuggestParms() {}
    virtual SuggestParms * clone() const {return new SuggestParms(*this);}
    virtual void set_original_word_size(int size) {
      if (size <= small_word_threshold) {
	soundslike_weight = small_word_soundslike_weight;
      } else {
	soundslike_weight = normal_soundslike_weight;
      }
      word_weight = 100 - soundslike_weight;
    }
  };
  
  Suggest * new_default_suggest(const Manager *, const SuggestParms &);
}

#endif
