//
// Copyright 1998 by Kevin Atkinson under the terms of the LGPL.
//
#include "language_exceps.hh" 

namespace aspell {

  //string Duplicates::message() const {
  //  return "There were duplicate words in the input.  The file \"" + file
  //    + "\" containes a word list without the duplicates."
  //    "  Please rerun with that file as input.";
  //}
  
  UnknownLang::UnknownLang(const string & l) 
    : LanguageException(l) 
  {
    message  = "Sorry the language \"";
    message += language;
    message += "\" is not known.";
  }

  void UnknownLang::rethrow_w_file(const string &f) const {
    throw UnknownLangInFile(language,f);
  }

  UnknownLangInFile::UnknownLangInFile(const string & l, const string & f) 
    : UnknownLang(l), FileException(f) 
  {
    message = "Sorry the language \"";
    message += language;
    message += "\" is not known.";
    if (!file.empty()) {
      message += " In file \"";
      message += file; 
      message += "\".";
    }
  }
  
  UnknownSoundslike::UnknownSoundslike(const string & s, 
				       const string & p,
				       const string & l)
    : LanguageException(l), soundslike(s), soundslike_path(p)
  {
    message =  "Sorry either the soundslike class \"";
    message += soundslike;
    message += "\" is not known or the file \"";
    message += soundslike_path;
    message += "\" could not be opened for reading. ";
    message += "This soundslike was found in the defination for the \"";
    message += language;
    message += "\" language.";
  }
  
  MismatchedLang::MismatchedLang(const string & c, 
				 const string & tried_language)
    : LanguageException(tried_language), current_language(c)
  {
    message  = "Sorry the language \"";
    message += language;
    message += "\" is not the same as the current language which is ";
    message += current_language;
    message += "\".";
  }
  
  void MismatchedLang::rethrow_w_file(const string & f) const {
    throw MismatchedLangInFile(current_language, language, f); 
  }

  MismatchedLangInFile::MismatchedLangInFile(const string & c, 
					     const string & l, 
					     const string & f)
    : MismatchedLang(c,l), FileException(f)
  {
    message =  "Sorry the language \"";
    message += language;
    message += "\" in file \"";
    message += file;
    message += "\" is not the same as the current language which is ";
    message += current_language;
    message += ".";
  }

}
