#ifndef __autil_hash_t_hh__
#define __autil_hash_t_hh__

#include "vector_hash.hh"
#include "primes.hh"

namespace autil {

  template <class Parms>
  pair<int,bool> 
  VectorHashTable<Parms>::find_item(const key_type & key) const {
    int start = hash1(key);
    int i = start;
    int h2 = hash2(key);
    int c =  bucket_count();
    for (;;) {
      if (parms_.is_nonexistent(vector_[i]) ) 
	return pair<int,bool>(i, false);
      if (parms_.equal(parms_.key(vector_[i]), key)) 
	return pair<int,bool>(i,true);
      i = (i + h2) % c;
      if (i == start) 
	return pair<int,bool>(i,false);
    }
  }

  template<class Parms>
  void VectorHashTable<Parms>::nonexistent_vector() {
    vector_iterator vector_end = vector_.end();
    for (vector_iterator i = vector_.begin(); i != vector_end; ++i) {
      parms_.make_nonexistent(*i);
    }
  }
  
  template<class Parms>
  pair<VectorHashTable<Parms>::iterator, bool> 
  VectorHashTable<Parms>::insert(const VectorHashTable<Parms>::value_type &d) {
    pair<int,bool> j = find_item(parms_.key(d));
    vector_iterator i = vector_.begin() + j.first;
    if (j.second) 
      return pair<iterator,bool>(iterator(i,this),false);

    if (load_factor() > .8) {
      resize(bucket_count()*1.5);
      return insert(d);
    } else {
      *i = d;
      ++size_;
    }
    return pair<iterator,bool>(iterator(i,this),true);
  }

  template<class Parms>
  bool VectorHashTable<Parms>::count(const VectorHashTable<Parms>::key_type & key) const {
    return find_item(key).second;
  }

  template<class Parms>
  VectorHashTable<Parms>::iterator 
  VectorHashTable<Parms>::find(const VectorHashTable<Parms>::key_type & key) {
    pair<int,bool> j = find_item(parms_.key(d));
    if (j.second) 
      return iterator(vector_.begin() + j.first, this);
    else
      return end();
  }

  template<class Parms>
  VectorHashTable<Parms>::const_iterator 
  VectorHashTable<Parms>::find(const VectorHashTable<Parms>::key_type & key) const {
    pair<int,bool> j = find_item(key);
    if (j.second) 
      return const_iterator(vector_.begin() + j.first, this);
    else
      return end();
  }

  template<class Parms>
  VectorHashTable<Parms>::size_type 
  VectorHashTable<Parms>::erase(const VectorHashTable<Parms>::key_type & key) {
    pair<int,bool> j = find_item(key);
    if (j.second) {
      erase(iterator(vector_.begin() + j.first, this));
      return 1;
    } else {
      return 0;
    }
  }

  template<class Parms>
  void VectorHashTable<Parms>::erase(const VectorHashTable<Parms>::iterator &p) {
    vector_iterator pos = p.vector_iterator();
    make_nonexistent_(*pos);
    vector_iterator vector_end = vector_.end();

    vector_iterator e = pos;
    do {
      ++e;
      if (e == vector_end) e = vector_.begin();
    } while (!is_nonexistent_(*e));

    vector_iterator should_be;
    while (pos != e) {
      if (is_nonexistent_(*pos)) {
	should_be = find_item_v(*pos);
	if (is_nonexistent_(*should_be)) {
	  *should_be = *pos;
	  make_nonexistent_(*pos);
	}
      }
      ++pos;
      if (pos == vector_end) pos = vector_.begin();
    }
    --size_;
  }

  template<class Parms>
  void VectorHashTable<Parms>::swap(VectorHashTable<Parms> &other) {
    vector_.swap(other.vector_);
    size_type temp = size_;
    size_ = other.size_;
    other.size_ = temp;
  }

  template<class Parms>
  void VectorHashTable<Parms>::resize(size_type i) {
    if (i < 7) {
      i = 7;
    } else {
      size_type j =  ((i - 3)/4)*4 + 3;
      if (j == i) 
	i = j;
      else
	i = j + 4;
      Primes p(sqrt(i)+2);
      for (;;) {
	if (i > p.max_num())
	  p.resize(sqrt(i)+2);
	if (p.is_prime(i) && p.is_prime(i-2))
	  break;
	i += 4;
      }
    }
    VectorHashTable temp(i);
    iterator e = end();
    for (iterator i = begin(); i != e; ++i)
      temp.insert(*i);
    swap(temp);
  }

  template<class Parms>
  void VectorHashTable<Parms>::recalc_size() {
    size_ = 0;
    for (iterator i = begin(); i != e; ++i, ++_size);
  }

}

#endif
